/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGGraphicsRenderer;
import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.EntityRendererImpl;
import com.apple.library.uikit.UIFont;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractGraphicsRendererImpl;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreenImpl;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractGraphicsRenderer
implements CGGraphicsRenderer,
CGGraphicsState {
    private static final IBufferSource SHARED_BUFFERS = AbstractBufferSource.create(256);
    private final IPoseStack poseStack;
    private final PoseStack originPoseStack;
    private final CGPoint mousePos;
    private final float partialTicks;
    private final AbstractMenuScreenImpl<?> screen;

    public AbstractGraphicsRenderer(AbstractMenuScreenImpl<?> screen, PoseStack poseStack, float mouseX, float mouseY, float partialTicks) {
        this.screen = screen;
        this.originPoseStack = poseStack;
        this.poseStack = AbstractPoseStack.wrap(poseStack);
        this.mousePos = new CGPoint(mouseX, mouseY);
        this.partialTicks = partialTicks;
    }

    public static PoseStack of(CGGraphicsContext context) {
        AbstractGraphicsRenderer impl = (AbstractGraphicsRenderer)Objects.unsafeCast(context.state());
        return impl.originPoseStack;
    }

    public static CGGraphicsContext of(AbstractMenuScreenImpl<?> screen, PoseStack poseStack, float mouseX, float mouseY, float partialTicks) {
        AbstractGraphicsRenderer impl = new AbstractGraphicsRenderer(screen, poseStack, mouseX, mouseY, partialTicks);
        return new CGGraphicsContext(impl, impl);
    }

    @Override
    public void renderTooltip(NSString text, CGRect rect, UIFont font, CGGraphicsContext context) {
        List texts = font.impl().m_92923_((FormattedText)text.component(), 100000);
        this.screen._renderTooltip(this.originPoseStack, texts, (int)this.mousePos.x, (int)this.mousePos.y);
    }

    @Override
    public void renderTooltip(ItemStack itemStack, CGRect rect, UIFont font, CGGraphicsContext context) {
        this.screen._renderTooltip(this.originPoseStack, itemStack, (int)this.mousePos.x, (int)this.mousePos.y);
    }

    @Override
    public void renderEntity(Entity entity, CGPoint origin, int scale, CGPoint focus, CGGraphicsContext context) {
        EntityRendererImpl<Entity> renderer = AbstractGraphicsRendererImpl.getRenderer(entity);
        renderer.render(entity, origin, scale, focus, context);
    }

    @Override
    public void renderItem(ItemStack itemStack, int x, int y, CGGraphicsContext context) {
        EnvironmentManager.getClient().m_91291_().m_115218_(itemStack, x, y);
    }

    @Override
    public void flush() {
        SHARED_BUFFERS.endBatch();
    }

    @Override
    public CGPoint mousePos() {
        return this.mousePos;
    }

    @Override
    public float partialTicks() {
        return this.partialTicks;
    }

    @Override
    public IBufferSource bufferSource() {
        return SHARED_BUFFERS;
    }

    @Override
    public IPoseStack ctm() {
        return this.poseStack;
    }
}

