/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.impl.EntityRendererImpl;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractGraphicsRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractGraphicsRendererImpl {
    private static final EntityRendererImpl<LivingEntity> DEFAULT_ENTITY_RENDERER = (entity, origin, scale, focus, context) -> {
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(AbstractGraphicsRenderer.of(context).m_85850_().m_85861_());
        modelViewStack.m_85837_((double)origin.x, (double)origin.y, 0.0);
        RenderSystem.m_157182_();
        InventoryScreen.m_98850_((int)0, (int)0, (int)scale, (float)focus.x, (float)focus.y, (LivingEntity)entity);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    };
    private static final EntityRendererImpl<Entity> CUSTOM_ENTITY_RENDERER = (entity, origin, scale, focus, context) -> {
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(AbstractGraphicsRenderer.of(context).m_85850_().m_85861_());
        modelViewStack.m_85837_((double)origin.x, (double)origin.y, 1050.0);
        modelViewStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        float h = (float)Math.atan(focus.x / 40.0f);
        float l = (float)Math.atan(focus.y / 40.0f);
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(0.0, 0.0, 1000.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        OpenQuaternionf quaternion = OpenVector3f.ZP.rotationDegrees(180.0f);
        OpenQuaternionf quaternion2 = OpenVector3f.XP.rotationDegrees(l * 20.0f);
        quaternion.mul(OpenVector3f.YP.rotationDegrees(180.0f));
        quaternion.mul(quaternion2);
        ABI.mulPose(poseStack, quaternion);
        float n = entity.m_146908_();
        float o = entity.m_146909_();
        entity.m_146922_(h * 40.0f);
        entity.m_146926_(-l * 20.0f);
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternion2.conjugate();
        entityRenderDispatcher.m_114412_(AbstractPoseStack.copyQuaternion(quaternion2));
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        entity.m_146922_(n);
        entity.m_146926_(o);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    };

    public static <T extends Entity> EntityRendererImpl<T> getRenderer(T entity) {
        if (entity instanceof LivingEntity) {
            return DEFAULT_ENTITY_RENDERER;
        }
        return CUSTOM_ENTITY_RENDERER;
    }
}

