/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.shader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import moe.plushie.armourers_workshop.core.utils.StreamUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractResourceProviderImpl
implements ResourceProvider {
    private final ResourceProvider impl;

    public AbstractResourceProviderImpl(ResourceProvider provider) {
        this.impl = provider;
    }

    public abstract Function<String, String> getTransformer(ResourceLocation var1);

    public Resource m_142591_(ResourceLocation location) throws IOException {
        final Resource resource = this.impl.m_142591_(location);
        final Function<String, String> transformer = this.getTransformer(location);
        if (transformer == null) {
            return resource;
        }
        return new Resource(){

            public ResourceLocation m_7843_() {
                return resource.m_7843_();
            }

            public InputStream m_6679_() {
                InputStream inputStream = resource.m_6679_();
                try {
                    String source = StreamUtils.readStreamToString(inputStream, StandardCharsets.UTF_8);
                    source = (String)transformer.apply(source);
                    return new ByteArrayInputStream(source.getBytes());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return inputStream;
                }
            }

            public boolean m_142564_() {
                return resource.m_142564_();
            }

            @Nullable
            public <T> T m_5507_(MetadataSectionSerializer<T> metadataSectionSerializer) {
                return (T)resource.m_5507_(metadataSectionSerializer);
            }

            public String m_7816_() {
                return resource.m_7816_();
            }

            public void close() throws IOException {
                resource.close();
            }
        };
    }
}

