/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractFriendlyByteBufImpl
implements IFriendlyByteBuf {
    protected final FriendlyByteBuf source;

    protected AbstractFriendlyByteBufImpl(FriendlyByteBuf source) {
        this.source = source;
    }

    protected static FriendlyByteBuf cast(ByteBuf buf) {
        FriendlyByteBuf source = Objects.safeCast(buf, FriendlyByteBuf.class);
        if (source == null) {
            source = new FriendlyByteBuf(buf);
        }
        return source;
    }

    protected static FriendlyByteBuf map(ByteBuf buf, Function<ByteBuf, ByteBuf> transform) {
        return new FriendlyByteBuf(transform.apply(buf));
    }

    @Override
    public GlobalPos readGlobalPos() {
        try {
            return (GlobalPos)this.source.m_130057_(GlobalPos.f_122633_);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void writeGlobalPos(GlobalPos value) {
        try {
            this.source.m_130059_(GlobalPos.f_122633_, (Object)value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ItemStack readItem() {
        return this.source.m_130267_();
    }

    @Override
    public void writeItem(ItemStack value) {
        this.source.m_130055_(value);
    }

    @Override
    public Component readComponent() {
        return this.source.m_130238_();
    }

    @Override
    public void writeComponent(Component component) {
        this.source.m_130083_(component);
    }

    @Override
    public <T> T readNbtWithCodec(IDataCodec<T> codec) {
        DataResult dataResult = codec.codec().parse((DynamicOps)NbtOps.f_128958_, (Object)this.readNbt());
        return (T)dataResult.getOrThrow(false, string -> {
            throw new DecoderException("Failed to decode nbt: " + string);
        });
    }

    @Override
    public <T> void writeNbtWithCodec(IDataCodec<T> codec, T value) {
        DataResult dataResult = codec.codec().encodeStart((DynamicOps)NbtOps.f_128958_, value);
        this.writeNbt((CompoundTag)dataResult.getOrThrow(false, string -> {
            throw new EncoderException("Failed to encode: " + string + " " + String.valueOf(value));
        }));
    }
}

