/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IBlockEntityCapability;
import moe.plushie.armourers_workshop.api.common.IEntityCapability;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeCapabilityManagerImpl;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.CapabilityItemHandler;

public class AbstractForgeCapabilityManager {
    public static <T> IRegistryHolder<IEntityCapability<T>> registerEntity(IResourceLocation registryName, Class<T> type, Function<Entity, Optional<T>> factory) {
        if (type == SkinWardrobe.class) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractForgeCapabilityManager.createWardrobeCapability(registryName, (Function)Objects.unsafeCast(factory)));
        }
        throw new AssertionError();
    }

    public static <T> IRegistryHolder<IBlockEntityCapability<T>> registerBlockEntity(IResourceLocation registryName, Class<T> type, Function<Entity, Optional<T>> factory) {
        if (registryName.equals(ModConstants.key("item"))) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractForgeCapabilityManager.createSidedCapability(registryName, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY));
        }
        if (registryName.equals(ModConstants.key("fluid"))) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractForgeCapabilityManager.createSidedCapability(registryName, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
        }
        if (registryName.equals(ModConstants.key("energy"))) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractForgeCapabilityManager.createSidedCapability(registryName, CapabilityEnergy.ENERGY));
        }
        throw new AssertionError();
    }

    private static IRegistryHolder<IEntityCapability<SkinWardrobe>> createWardrobeCapability(IResourceLocation registryName, Function<Entity, Optional<SkinWardrobe>> provider) {
        Capability capability = CapabilityManager.get((CapabilityToken)new CapabilityToken<SkinWardrobe>(){});
        IEntityCapability capabilityType = entity -> entity.getCapability(capability).resolve();
        return new HolderProxy<SkinWardrobe>(registryName, SkinWardrobe.class, provider, capabilityType, () -> capability);
    }

    private static <T> IRegistryHolder<IBlockEntityCapability<T>> createSidedCapability(IResourceLocation registryName, Capability<T> capability) {
        return TypedRegistry.Entry.castValue(registryName, AbstractForgeCapabilityManagerImpl.wrap(capability));
    }

    private static class HolderProxy<T extends IDataSerializable.Mutable>
    extends AbstractForgeCapabilityManagerImpl.HolderProxy<T> {
        protected HolderProxy(IResourceLocation registryName, Class<T> type, Function<Entity, Optional<T>> factory, IEntityCapability<T> capabilityType, Supplier<Capability<T>> capability) {
            super(registryName, type, factory, capabilityType, capability);
            MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, this::attachEntityCapability);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCapability);
        }

        public void registerCapability(RegisterCapabilitiesEvent event) {
            event.register(this.type);
        }

        public void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
            AbstractForgeCapabilityManagerImpl.CapabilityProxy value = this.attach((Entity)event.getObject());
            if (value != null) {
                event.addCapability(this.registryName.toLocation(), value);
            }
        }
    }
}

