/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IPacketDistributor;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractFriendlyByteBuf;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;

public class AbstractForgeNetwork {

    public static class Distributors
    implements NetworkManager.Distributors {
        @Override
        public IPacketDistributor trackingChunk(Supplier<LevelChunk> supplier) {
            return new Distributor(PacketDistributor.TRACKING_CHUNK.with(supplier), null);
        }

        @Override
        public IPacketDistributor trackingEntityAndSelf(Supplier<Entity> supplier) {
            return new Distributor(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(supplier), null);
        }

        @Override
        public IPacketDistributor player(Supplier<ServerPlayer> supplier) {
            return new Distributor(PacketDistributor.PLAYER.with(supplier), null);
        }

        @Override
        public IPacketDistributor allPlayers() {
            return new Distributor(PacketDistributor.ALL.noArg(), null);
        }

        @Override
        public IPacketDistributor server() {
            return new Distributor(PacketDistributor.SERVER.noArg(), null);
        }
    }

    public static class Distributor
    implements IPacketDistributor {
        private final PacketDistributor.PacketTarget target;
        private final Packet<?> packet;

        Distributor(PacketDistributor.PacketTarget target, Packet<?> packet) {
            this.target = target;
            this.packet = packet;
        }

        @Override
        public IPacketDistributor add(IResourceLocation channel, IFriendlyByteBuf buf) {
            NetworkDirection direction = this.target.getDirection();
            Packet packet1 = direction.buildPacket(Pair.of((Object)((FriendlyByteBuf)buf.asByteBuf()), (Object)0), channel.toLocation()).getThis();
            return new Distributor(this.target, packet1);
        }

        @Override
        public void execute() {
            if (this.packet == null) {
                return;
            }
            NetworkDirection direction = this.target.getDirection();
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(direction.getOriginationSide());
            executor.m_18689_(() -> this.target.send(this.packet));
        }

        @Override
        public boolean isClientbound() {
            return this.target.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
        }
    }

    public static class Dispatcher
    extends NetworkManager.Dispatcher {
        public Dispatcher(IResourceLocation channelName, String channelVersion) {
            super(channelName, channelVersion);
        }

        @Override
        public void register() {
            EventNetworkChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.channelName.toLocation()).networkProtocolVersion(() -> this.channelVersion).clientAcceptedVersions(sv -> true).serverAcceptedVersions(cv -> {
                if (ModConfig.Common.enableProtocolCheck) {
                    return cv.equals(this.channelVersion);
                }
                return true;
            }).eventNetworkChannel();
            channel.registerObject((Object)this);
        }

        @SubscribeEvent
        public void onServerEvent(NetworkEvent.ClientCustomPayloadEvent event) {
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            IServerPacketHandler packetHandler = arg_0 -> ((NetworkEvent.Context)context).enqueueWork(arg_0);
            AbstractFriendlyByteBuf payload = AbstractFriendlyByteBuf.wrap((ByteBuf)event.getPayload());
            this.didReceivePacket(packetHandler, (IFriendlyByteBuf)payload, player);
            context.setPacketHandled(true);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void onClientEvent(NetworkEvent.ServerCustomPayloadEvent event) {
            if (event instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
                return;
            }
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            IClientPacketHandler packetHandler = arg_0 -> ((NetworkEvent.Context)context).enqueueWork(arg_0);
            AbstractFriendlyByteBuf payload = AbstractFriendlyByteBuf.wrap((ByteBuf)event.getPayload());
            this.didReceivePacket(packetHandler, (IFriendlyByteBuf)payload, null);
            context.setPacketHandled(true);
        }
    }
}

