/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge.event.common;

import moe.plushie.armourers_workshop.api.registry.IEventHandler;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeCommonEventsImpl;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.event.common.ServerLevelAddEntityEvent;
import moe.plushie.armourers_workshop.init.event.common.ServerLevelTickEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class AbstractForgeServerLevelEvent {
    public static IEventHandler<ServerLevelTickEvent.Pre> preTickFactory() {
        return AbstractForgeCommonEventsImpl.SERVER_LEVEL_TICK_PRE.flatMap(event -> {
            ServerLevel serverLevel = Objects.safeCast(event.world, ServerLevel.class);
            if (serverLevel != null && event.phase == TickEvent.Phase.START) {
                return () -> serverLevel;
            }
            return null;
        });
    }

    public static IEventHandler<ServerLevelTickEvent.Post> postTickFactory() {
        return AbstractForgeCommonEventsImpl.SERVER_LEVEL_TICK_POST.flatMap(event -> {
            ServerLevel serverLevel = Objects.safeCast(event.world, ServerLevel.class);
            if (serverLevel != null && event.phase == TickEvent.Phase.END) {
                return () -> serverLevel;
            }
            return null;
        });
    }

    public static IEventHandler<ServerLevelAddEntityEvent> addEntityFactory() {
        return AbstractForgeCommonEventsImpl.SERVER_LEVEL_ADD_ENTITY.flatMap(event -> {
            ServerLevel serverLevel = Objects.safeCast(event.getWorld(), ServerLevel.class);
            if (serverLevel != null) {
                return () -> ((EntityJoinWorldEvent)event).getEntity();
            }
            return null;
        });
    }
}

