/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation.handler;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.resources.sounds.SoundInstance.Constructor;
import moe.plushie.armourers_workshop.core.client.sound.SmartSoundManager;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationPoint;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.BlockEntitySelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EntitySelectorImpl;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundData;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundProperties;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OptimizedExpression;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;

public class AnimationSoundHandler
implements OptimizedExpression<Object> {
    private final String name;
    private final SoundEvent soundEvent;
    private final float volume;
    private final float pitch;

    public AnimationSoundHandler(SkinAnimationPoint.Sound sound) {
        SkinSoundData soundProvider = sound.provider();
        SkinSoundProperties soundProperties = soundProvider.properties();
        this.name = sound.effect();
        this.volume = soundProperties.volume();
        this.pitch = soundProperties.pitch();
        this.soundEvent = SmartSoundManager.getInstance().register(soundProvider);
    }

    @Override
    public Runnable evaluate(ExecutionContext context) {
        SmartSoundManager.getInstance().open(this.soundEvent);
        SoundInstance sound = this.createSound(context);
        this.startPlay(sound);
        return () -> {
            this.stopPlay(sound);
            RenderSystem.m_69879_(() -> SmartSoundManager.getInstance().close(this.soundEvent));
        };
    }

    private void startPlay(SoundInstance sound) {
        this.soundManager().m_120367_(sound);
        if (ModConfig.Client.enableAnimationDebug) {
            ModLog.debug("start play {}", this);
        }
    }

    private void stopPlay(SoundInstance sound) {
        this.soundManager().m_120399_(sound);
        if (ModConfig.Client.enableAnimationDebug) {
            ModLog.debug("stop play {}", this);
        }
    }

    private SoundInstance createSound(ExecutionContext context) {
        if (context instanceof BlockEntitySelectorImpl) {
            BlockEntitySelectorImpl entity = (BlockEntitySelectorImpl)((Object)context);
            return Constructor.forBlockEntity(SoundInstance.class, this.soundEvent, entity.getEntity(), this.volume, this.pitch);
        }
        if (context instanceof EntitySelectorImpl) {
            EntitySelectorImpl entity = (EntitySelectorImpl)((Object)context);
            return Constructor.forEntity(SoundInstance.class, this.soundEvent, entity.entity(), this.volume, this.pitch);
        }
        return Constructor.forUI(SoundInstance.class, this.soundEvent, this.volume, this.pitch);
    }

    private SoundManager soundManager() {
        return EnvironmentManager.getClient().m_91106_();
    }

    public String toString() {
        return Objects.toString(this, "name", this.name);
    }
}

