/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.FileProviderSettingDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinFileList;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFile;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraft.Util;

public class FileProviderDialog
extends ConfirmDialog {
    private final SkinFileList<FileItem> fileList = new SkinFileList(new CGRect(0.0f, 0.0f, 100.0f, 100.0f));
    private final File rootPath;
    private final String extension;
    private FileItem selectedFile;
    private String selectedPath;
    protected SkinProperties properties = new SkinProperties();

    public FileProviderDialog(File rootPath, String extension) {
        this.rootPath = rootPath;
        this.extension = extension;
        this.setFrame(new CGRect(0.0f, 0.0f, 240.0f, 200.0f));
        this.setTitle(NSString.localizedString("skin-library.dialog.fileProvider.title", new Object[0]));
        this.setMessage(NSString.localizedString("skin-library.dialog.fileProvider.message", extension));
        this.setup(this.bounds());
    }

    private void setup(CGRect rect) {
        CGPoint messageOffset = this.messageLabel.center().copy();
        messageOffset.y -= 10.0f;
        this.messageLabel.setCenter(messageOffset);
        this.fileList.setFrame(rect.insetBy(40.0f, 10.0f, 40.0f, 10.0f));
        this.fileList.setAutoresizingMask(18);
        this.fileList.addTarget((FileItem)((Object)this), UIControl.Event.VALUE_CHANGED, (BiConsumer<FileItem, UIControl>)((BiConsumer<FileProviderDialog, UIControl>)FileProviderDialog::selectFile));
        this.addSubview(this.fileList);
        this.confirmButton.setTooltip(NSString.localizedString("skin-library.dialog.fileProvider.tooltip", this.extension), 4);
        this.confirmButton.setEnabled(false);
        UIButton setting = new UIButton(new CGRect(rect.width() - 24.0f - 8.0f, 4.0f, 24.0f, 16.0f));
        setting.setBackgroundImage(UIImage.of(ModTextures.SKINNING_TABLE).uv(228.0f, 0.0f).resizable(24.0f, 16.0f).build(), 7);
        setting.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, FileProviderDialog::settingAction);
        this.addSubview(setting);
        this.selectPath("");
    }

    private void setupEmptyView() {
        CGRect rect = this.fileList.bounds();
        UIView emptyView = new UIView(this.fileList.frame());
        emptyView.setAutoresizingMask(this.fileList.autoresizingMask());
        UIImageView bg1 = new UIImageView(rect);
        bg1.setImage(UIImage.of(ModTextures.LIST).fixed(11.0f, 11.0f).clip(1.0f, 1.0f, 1.0f, 1.0f).build());
        bg1.setAutoresizingMask(18);
        emptyView.addSubview(bg1);
        float top = (rect.height - 50.0f) / 2.0f;
        UILabel titleView = new UILabel(new CGRect(10.0f, top, rect.width - 20.0f, 30.0f));
        titleView.setText(NSString.localizedString("skin-library.dialog.fileProvider.emptyFolder", new Object[]{this.extension, this.rootPath.getName()}));
        titleView.setTextColor(UIColor.GRAY);
        titleView.setAutoresizingMask(34);
        titleView.setTextHorizontalAlignment(NSTextAlignment.Horizontal.CENTER);
        titleView.setTextVerticalAlignment(NSTextAlignment.Vertical.TOP);
        titleView.setNumberOfLines(0);
        emptyView.addSubview(titleView);
        UIButton openButton = new UIButton(new CGRect((rect.width - 100.0f) / 2.0f, top + 30.0f, 100.0f, 20.0f));
        openButton.setTitle(NSString.localizedString("skin-library.dialog.fileProvider.openFolder", new Object[0]), 7);
        openButton.setTitleColor(UIColor.WHITE, 7);
        openButton.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        openButton.setAutoresizingMask(13);
        openButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, FileProviderDialog::openFolder);
        emptyView.addSubview(openButton);
        this.addSubview(emptyView);
    }

    private void settingAction(UIControl control) {
        FileProviderSettingDialog alert = new FileProviderSettingDialog(this.properties);
        alert.showInView(this, () -> {
            if (!alert.isCancelled()) {
                this.properties = alert.properties();
            }
        });
    }

    private void selectFile(UIControl control) {
        FileItem newValue;
        FileItem oldValue = this.selectedFile;
        this.selectedFile = newValue = this.fileList.selectedItem();
        this.confirmButton.setEnabled(newValue != null && !newValue.isDirectory());
        if (newValue != null && newValue.isDirectory() && oldValue == newValue) {
            this.selectPath(newValue.path());
        }
    }

    private void selectPath(String newSelectedPath) {
        if (Objects.equals(this.selectedPath, newSelectedPath)) {
            return;
        }
        this.selectedPath = newSelectedPath;
        File targetPath = new File(this.rootPath, this.selectedPath);
        ArrayList<FileItem> items = this.getSkinFiles(targetPath, false);
        String path = FileUtils.getRelativePath(targetPath, this.rootPath, true);
        if (path != null && !path.equals("/")) {
            items.add(0, new FileItem("..", newSelectedPath + "/..", true));
        }
        this.fileList.reloadData(new ArrayList<FileItem>(items));
        if (items.isEmpty()) {
            this.setupEmptyView();
        }
    }

    private void openFolder(UIControl sender) {
        Util.m_137581_().m_137644_(this.rootPath);
    }

    public File selectedFile() {
        if (this.selectedFile == null || this.selectedFile.isDirectory()) {
            return null;
        }
        return new File(this.rootPath, this.selectedFile.path());
    }

    private ArrayList<FileItem> getSkinFiles(File directory, boolean recursive) {
        ArrayList<FileItem> fileList = new ArrayList<FileItem>();
        List<File> templateFiles = FileUtils.listFiles(directory);
        if (templateFiles.isEmpty()) {
            return fileList;
        }
        for (File file : templateFiles) {
            String path = FileUtils.getRelativePath(file, this.rootPath, true);
            String filename = file.getName();
            if (file.isDirectory()) {
                fileList.add(new FileItem(filename, path, true));
                continue;
            }
            if (!filename.toLowerCase().endsWith(this.extension)) continue;
            String name = FileUtils.getBaseName(filename);
            fileList.add(new FileItem(name, path, false));
        }
        fileList.sort(null);
        if (recursive) {
            for (File file : templateFiles) {
                if (!file.isDirectory()) continue;
                fileList.addAll(this.getSkinFiles(file, true));
            }
        }
        return fileList;
    }

    public SkinProperties properties() {
        return this.properties;
    }

    public static class FileItem
    extends SkinFile {
        public FileItem(String name, String path, boolean isDirectory) {
            super(DataDomain.LOCAL, name, path, null, isDirectory, false);
        }

        @Override
        public String skinIdentifier() {
            return null;
        }
    }
}

