/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderHelper;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderTesselator
extends SkinRenderContext {
    private final BakedSkin bakedSkin;
    private final BakedArmature bakedArmature;
    private final MannequinEntity mannequin;

    public SkinRenderTesselator(BakedSkin bakedSkin, BakedArmature bakedArmature, MannequinEntity mannequin) {
        super(null);
        this.bakedSkin = bakedSkin;
        this.mannequin = mannequin;
        this.bakedArmature = bakedArmature;
    }

    public static SkinRenderTesselator create(Ticket<String> ticket) {
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(ticket);
        if (bakedSkin != null) {
            return SkinRenderTesselator.create(bakedSkin);
        }
        return null;
    }

    public static SkinRenderTesselator create(BakedSkin bakedSkin) {
        MannequinEntity mannequin = PlaceholderManager.MANNEQUIN.get();
        BakedArmature bakedArmature = BakedArmature.defaultBy(bakedSkin.type());
        if (bakedArmature == null || mannequin == null || mannequin.m_183503_() == null) {
            return null;
        }
        return new SkinRenderTesselator(bakedSkin, bakedArmature, mannequin);
    }

    public int draw() {
        this.bakedSkin.setupAnim((Entity)this.mannequin, this.bakedArmature, this);
        SkinPaintScheme paintScheme = this.bakedSkin.resolve((Entity)this.mannequin, this.colorScheme());
        if (this.isUseItemTransforms()) {
            BakedItemTransform itemTransform = this.bakedSkin.itemTransform();
            itemTransform.apply(this.poseStack, (Entity)this.mannequin(), this.bakedSkin, this);
        }
        SkinRenderer.render((Entity)this.mannequin, this.bakedArmature, this.bakedSkin, paintScheme, this);
        return SkinRenderHelper.getRenderCount(this.bakedSkin);
    }

    public MannequinEntity mannequin() {
        return this.mannequin;
    }

    public BakedSkin skin() {
        return this.bakedSkin;
    }
}

