/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Scheduler;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class SkinContainerEvaluator {
    private final ArrayList<Consumer<List<Skin>>> handlers = new ArrayList();
    private final Map<Integer, ItemStack> lastSlots = new HashMap<Integer, ItemStack>();
    private final Map<Integer, SkinDescriptor> lastSkinDescriptors = new HashMap<Integer, SkinDescriptor>();
    private final Map<String, Info> loadedSkins = new ConcurrentHashMap<String, Info>();
    private boolean updating;

    public SkinContainerEvaluator(SimpleContainer container) {
        container.m_19164_(this::containerDidChange);
    }

    public void reset() {
        this.lastSlots.clear();
        this.lastSkinDescriptors.clear();
        this.loadedSkins.clear();
    }

    public void beginUpdates() {
        this.updating = true;
    }

    public void endUpdates() {
        this.updating = false;
    }

    public void addListener(Consumer<List<Skin>> handler) {
        this.handlers.add(handler);
    }

    public void removeListener(Consumer<List<Skin>> handler) {
        this.handlers.remove(handler);
    }

    private void containerDidChange(Container container) {
        if (this.updating) {
            return;
        }
        int changes = 0;
        int size = container.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (itemStack == this.lastSlots.get(i)) continue;
            this.lastSlots.put(i, itemStack);
            this.lastSkinDescriptors.put(i, SkinDescriptor.of(itemStack));
            ++changes;
        }
        if (changes == 0) {
            return;
        }
        HashSet<SkinDescriptor> newValue = new HashSet<SkinDescriptor>(this.lastSkinDescriptors.values());
        HashSet<String> oldValue = new HashSet<String>(this.loadedSkins.keySet());
        newValue.removeIf(SkinDescriptor::isEmpty);
        if (newValue.isEmpty() && oldValue.isEmpty()) {
            this.infoDidChange();
            return;
        }
        newValue.forEach(it -> {
            String identifier = it.identifier();
            if (oldValue.remove(identifier)) {
                return;
            }
            Info info = new Info();
            this.loadedSkins.put(identifier, info);
            SkinLoader.getInstance().loadSkinInfo(identifier, (skin, exception) -> {
                info.update((Skin)skin, exception);
                Scheduler.SERVER.next(this::infoDidChange);
            });
        });
        oldValue.forEach(it -> {
            this.loadedSkins.remove(it);
            Scheduler.SERVER.next(this::infoDidChange);
        });
    }

    private void infoDidChange() {
        ArrayList<Skin> values = Collections.compactMap(this.loadedSkins.values(), it -> it.skin);
        this.handlers.forEach((Consumer<Consumer<List<Skin>>>)((Consumer<Consumer>)it -> it.accept(values)));
    }

    private static class Info {
        private Skin skin;

        private Info() {
        }

        public void update(Skin skin, Exception exception) {
            this.skin = skin;
        }
    }
}

