/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import moe.plushie.armourers_workshop.api.common.IEntityDataBuilder;
import moe.plushie.armourers_workshop.api.common.IEntityHandler;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.compatibility.core.AbstractLivingEntity;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.EntityDimensions.ABI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.item.option.MannequinToolOptions;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModEntitySerializers;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutorIO;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MannequinEntity
extends AbstractLivingEntity.ArmorStand
implements IEntityHandler,
IDataSerializable.Mutable {
    public static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    public static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    public static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    public static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    public static final EntityDimensions MARKER_DIMENSIONS = EntityDimensions.m_20398_((float)0.0f, (float)0.0f);
    public static final EntityDimensions BABY_DIMENSIONS = ABI.withEyeHeight(EntityDimensions.m_20395_((float)0.5f, (float)1.0f), 0.88f);
    public static final EntityDimensions STANDING_DIMENSIONS = ABI.withEyeHeight(EntityDimensions.m_20395_((float)0.6f, (float)1.88f), 1.62f);
    public static final EntityDataAccessor<Boolean> DATA_IS_CHILD = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_FLYING = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_GHOST = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_VISIBLE = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> DATA_EXTRA_RENDERER = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_NO_GRAVITY = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<EntityTextureDescriptor> DATA_TEXTURE = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.PLAYER_TEXTURE);
    public static final EntityDataAccessor<EntityTextureDescriptor.Model> DATA_TEXTURE_MODEL = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.PLAYER_TEXTURE_MODEL);
    private boolean isDropEquipment = false;
    private AABB boundingBoxForCulling;

    public MannequinEntity(EntityType<? extends MannequinEntity> entityType, Level level) {
        super((EntityType<? extends AbstractLivingEntity.ArmorStand>)entityType, level);
    }

    @Override
    protected void defineSynchedData(IEntityDataBuilder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_CHILD, false);
        builder.define(DATA_IS_FLYING, false);
        builder.define(DATA_IS_GHOST, false);
        builder.define(DATA_IS_VISIBLE, true);
        builder.define(DATA_EXTRA_RENDERER, true);
        builder.define(DATA_NO_GRAVITY, true);
        builder.define(DATA_SCALE, Float.valueOf(1.0f));
        builder.define(DATA_TEXTURE, EntityTextureDescriptor.EMPTY);
        builder.define(DATA_TEXTURE_MODEL, EntityTextureDescriptor.Model.STEVE);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.deserialize(new TagSerializer(tag));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.serialize(new TagSerializer(tag));
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.IS_SMALL, (Boolean)this.f_19804_.m_135370_(DATA_IS_CHILD));
        serializer.write(CodingKeys.IS_FLYING, (Boolean)this.f_19804_.m_135370_(DATA_IS_FLYING));
        serializer.write(CodingKeys.IS_GHOST, (Boolean)this.f_19804_.m_135370_(DATA_IS_GHOST));
        serializer.write(CodingKeys.IS_VISIBLE, (Boolean)this.f_19804_.m_135370_(DATA_IS_VISIBLE));
        serializer.write(CodingKeys.EXTRA_RENDER, (Boolean)this.f_19804_.m_135370_(DATA_EXTRA_RENDERER));
        serializer.write(CodingKeys.NO_GRAVITY, (Boolean)this.f_19804_.m_135370_(DATA_NO_GRAVITY));
        serializer.write(CodingKeys.SCALE, (Float)this.f_19804_.m_135370_(DATA_SCALE));
        serializer.write(CodingKeys.TEXTURE, (EntityTextureDescriptor)this.f_19804_.m_135370_(DATA_TEXTURE));
        serializer.write(CodingKeys.TEXTURE_MODEL, (EntityTextureDescriptor.Model)((Object)this.f_19804_.m_135370_(DATA_TEXTURE_MODEL)));
        serializer.write(CodingKeys.POSE, this.saveCustomPose());
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        this.f_19804_.m_135381_(DATA_IS_CHILD, (Object)serializer.read(CodingKeys.IS_SMALL));
        this.f_19804_.m_135381_(DATA_IS_FLYING, (Object)serializer.read(CodingKeys.IS_FLYING));
        this.f_19804_.m_135381_(DATA_IS_GHOST, (Object)serializer.read(CodingKeys.IS_GHOST));
        this.f_19804_.m_135381_(DATA_IS_VISIBLE, (Object)serializer.read(CodingKeys.IS_VISIBLE));
        this.f_19804_.m_135381_(DATA_EXTRA_RENDERER, (Object)serializer.read(CodingKeys.EXTRA_RENDER));
        this.f_19804_.m_135381_(DATA_NO_GRAVITY, (Object)serializer.read(CodingKeys.NO_GRAVITY));
        this.f_19804_.m_135381_(DATA_SCALE, (Object)serializer.read(CodingKeys.SCALE));
        this.f_19804_.m_135381_(DATA_TEXTURE, (Object)serializer.read(CodingKeys.TEXTURE));
        this.f_19804_.m_135381_(DATA_TEXTURE_MODEL, (Object)serializer.read(CodingKeys.TEXTURE_MODEL));
        this.readCustomPose(serializer.read(CodingKeys.POSE));
        this.m_6210_();
        this.refreshPhysics();
    }

    public void m_7350_(EntityDataAccessor<?> dataParameter) {
        if (DATA_IS_CHILD.equals(dataParameter)) {
            this.m_6210_();
        }
        if (DATA_SCALE.equals(dataParameter)) {
            this.m_6210_();
        }
        if (DATA_NO_GRAVITY.equals(dataParameter)) {
            this.refreshPhysics();
        }
        super.m_7350_(dataParameter);
    }

    public boolean isModelVisible() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_VISIBLE);
    }

    public void setModelVisible(boolean value) {
        this.f_19804_.m_135381_(DATA_IS_VISIBLE, (Object)value);
    }

    public float m_6134_() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public boolean m_31666_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHILD);
    }

    public boolean m_20068_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_NO_GRAVITY);
    }

    public void m_20242_(boolean bl) {
        this.f_19804_.m_135381_(DATA_NO_GRAVITY, (Object)bl);
    }

    public boolean isFakeFlying() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_FLYING);
    }

    public boolean m_5829_() {
        return this.m_6084_() && (Boolean)this.f_19804_.m_135370_(DATA_IS_GHOST) == false;
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.m_31677_()) {
            return MARKER_DIMENSIONS;
        }
        EntityDimensions entitySize = STANDING_DIMENSIONS;
        if (this.m_6162_()) {
            entitySize = BABY_DIMENSIONS;
        }
        return entitySize;
    }

    @Override
    public ItemStack getCustomPickResult(HitResult target) {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.MANNEQUIN.get());
        if (EnvironmentExecutorIO.hasControlDown()) {
            CompoundTag entityTag = new CompoundTag();
            entityTag.m_128359_("id", ModEntityTypes.MANNEQUIN.registryName().toString());
            this.m_7380_(entityTag);
            ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get(), entityTag);
        }
        return itemStack;
    }

    public void m_5618_(float f) {
        super.m_5618_(f);
        this.m_146922_(f);
        this.f_20883_ = f;
    }

    public void m_6034_(double d, double e, double f) {
        super.m_6034_(d, e, f);
        this.boundingBoxForCulling = null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.isDropEquipment = false;
        boolean flag = this.m_6084_();
        boolean flag1 = super.m_6469_(source, amount);
        Level level = this.m_183503_();
        if (!this.isDropEquipment && flag != this.m_6084_() && level instanceof ServerLevel) {
            this.brokenByAnything((ServerLevel)level, source);
        }
        return flag1;
    }

    public InteractionResult m_7111_(Player player, Vec3 pos, InteractionHand hand) {
        if (this.m_31677_()) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)ModItems.MANNEQUIN_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (itemStack.m_150930_(Items.f_42656_)) {
            return itemStack.m_41647_(player, (LivingEntity)this, hand);
        }
        if (player.m_36341_()) {
            if (EnvironmentExecutorIO.hasControlDown()) {
                return super.m_7111_(player, pos, hand);
            }
            double ry = OpenMath.getAngleDegrees(player.m_20185_(), player.m_20189_(), this.m_20185_(), this.m_20189_()) + 90.0;
            Rotations rotations = this.m_31685_();
            float yRot = this.m_146908_();
            this.m_31616_(new Rotations(rotations.m_123156_(), (float)ry - yRot, rotations.m_123158_()));
            return InteractionResult.m_19078_((boolean)this.m_183503_().m_5776_());
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)this);
        if (wardrobe != null && wardrobe.isEditable(player)) {
            ((IMenuType)ModMenuTypes.WARDROBE.get()).openMenu(player, wardrobe);
            return InteractionResult.m_19078_((boolean)this.m_183503_().m_5776_());
        }
        return InteractionResult.PASS;
    }

    @Override
    public void brokenByPlayer(ServerLevel serverLevel, DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_) {
                EntityData entityData = new EntityData();
                entityData.setScale(this.m_6134_());
                entityData.setTexture(this.getTextureDescriptor());
                Block.m_49840_((Level)this.m_183503_(), (BlockPos)this.m_142538_(), (ItemStack)entityData.itemStack());
            }
        }
        this.brokenByAnything(serverLevel, source);
    }

    protected void m_5907_() {
        super.m_5907_();
        this.isDropEquipment = true;
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)this);
        if (wardrobe != null) {
            wardrobe.dropAll(arg_0 -> ((MannequinEntity)this).m_19983_(arg_0));
        }
    }

    protected void refreshPhysics() {
        this.f_19794_ = !this.hasPhysics();
    }

    protected boolean hasPhysics() {
        return !this.m_31677_() && !this.m_20068_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB m_6921_() {
        if (this.boundingBoxForCulling != null) {
            return this.boundingBoxForCulling;
        }
        float f = this.m_6134_();
        this.boundingBoxForCulling = this.m_142469_().m_82377_((double)(f * 3.0f), (double)(f * 2.0f), (double)(f * 2.5f));
        return this.boundingBoxForCulling;
    }

    public EntityTextureDescriptor getTextureDescriptor() {
        return (EntityTextureDescriptor)this.f_19804_.m_135370_(DATA_TEXTURE);
    }

    public void setTextureDescriptor(EntityTextureDescriptor newValue) {
        this.f_19804_.m_135381_(DATA_TEXTURE, (Object)newValue);
    }

    public EntityTextureDescriptor.Model getTextureModel() {
        return (EntityTextureDescriptor.Model)((Object)this.f_19804_.m_135370_(DATA_TEXTURE_MODEL));
    }

    public void setTextureModel(EntityTextureDescriptor.Model newValue) {
        this.f_19804_.m_135381_(DATA_TEXTURE_MODEL, (Object)newValue);
    }

    public boolean isExtraRenderer() {
        return (Boolean)this.f_19804_.m_135370_(DATA_EXTRA_RENDERER);
    }

    public void setExtraRenderer(boolean value) {
        this.f_19804_.m_135381_(DATA_EXTRA_RENDERER, (Object)value);
    }

    public Container getInventory() {
        return new SimpleContainer(new ItemStack[]{this.m_21205_(), this.m_21206_()}){

            public void m_6836_(int index, ItemStack itemStack) {
                super.m_6836_(index, itemStack);
                MannequinEntity.this.m_8061_(EquipmentSlot.values()[index], itemStack);
            }
        };
    }

    public CompoundTag saveCustomPose() {
        TagSerializer serializer = new TagSerializer();
        serializer.write(CodingKeys.POSE_HEAD, (Rotations)this.f_19804_.m_135370_(f_31546_));
        serializer.write(CodingKeys.POSE_BODY, (Rotations)this.f_19804_.m_135370_(f_31547_));
        serializer.write(CodingKeys.POSE_LEFT_ARM, (Rotations)this.f_19804_.m_135370_(f_31548_));
        serializer.write(CodingKeys.POSE_RIGHT_ARM, (Rotations)this.f_19804_.m_135370_(f_31549_));
        serializer.write(CodingKeys.POSE_LEFT_LEG, (Rotations)this.f_19804_.m_135370_(f_31550_));
        serializer.write(CodingKeys.POSE_RIGHT_LEG, (Rotations)this.f_19804_.m_135370_(f_31527_));
        return serializer.tag();
    }

    public void readCustomPose(CompoundTag tag) {
        TagSerializer serializer = new TagSerializer(tag);
        this.m_31597_(serializer.read(CodingKeys.POSE_HEAD));
        this.m_31616_(serializer.read(CodingKeys.POSE_BODY));
        this.m_31623_(serializer.read(CodingKeys.POSE_LEFT_ARM));
        this.m_31628_(serializer.read(CodingKeys.POSE_RIGHT_ARM));
        this.m_31639_(serializer.read(CodingKeys.POSE_LEFT_LEG));
        this.m_31651_(serializer.read(CodingKeys.POSE_RIGHT_LEG));
    }

    public void saveMannequinToolData(CompoundTag entityTag) {
        this.serialize(new TagSerializer(entityTag));
    }

    public void readMannequinToolData(CompoundTag entityTag, ItemStack itemStack) {
        Tag oldValue;
        CompoundTag newEntityTag = new CompoundTag();
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_OPTION).booleanValue()) {
            newEntityTag.m_128391_(entityTag);
            newEntityTag.m_128473_(CodingKeys.SCALE.name());
            newEntityTag.m_128473_(CodingKeys.POSE.name());
            newEntityTag.m_128473_(CodingKeys.TEXTURE.name());
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_SCALE).booleanValue() && (oldValue = entityTag.m_128423_(CodingKeys.SCALE.name())) != null) {
            newEntityTag.m_128365_(CodingKeys.SCALE.name(), oldValue);
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_ROTATION).booleanValue()) {
            oldValue = OptionalAPI.getOptionalCompound(entityTag, CodingKeys.POSE.name()).orElseGet(CompoundTag::new);
            if (ToolAPI.get(itemStack, MannequinToolOptions.MIRROR_MODE).booleanValue() && !oldValue.m_128456_()) {
                TagSerializer poseSerializer = new TagSerializer(oldValue.m_6426_());
                poseSerializer.write(CodingKeys.POSE_HEAD, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_HEAD)));
                poseSerializer.write(CodingKeys.POSE_BODY, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_BODY)));
                poseSerializer.write(CodingKeys.POSE_LEFT_ARM, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_LEFT_ARM)));
                poseSerializer.write(CodingKeys.POSE_RIGHT_ARM, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_RIGHT_ARM)));
                poseSerializer.write(CodingKeys.POSE_LEFT_LEG, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_LEFT_LEG)));
                poseSerializer.write(CodingKeys.POSE_RIGHT_LEG, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_RIGHT_LEG)));
                oldValue = poseSerializer.tag();
            }
            newEntityTag.m_128365_(CodingKeys.POSE.name(), oldValue);
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_TEXTURE).booleanValue() && (oldValue = entityTag.m_128423_(CodingKeys.TEXTURE.name())) != null) {
            newEntityTag.m_128365_(CodingKeys.TEXTURE.name(), oldValue);
        }
        this.deserialize(new TagSerializer(newEntityTag));
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<Boolean> IS_SMALL = IDataSerializerKey.create("Small", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_FLYING = IDataSerializerKey.create("Flying", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_GHOST = IDataSerializerKey.create("Ghost", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_VISIBLE = IDataSerializerKey.create("ModelVisible", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> EXTRA_RENDER = IDataSerializerKey.create("ExtraRender", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> NO_GRAVITY = IDataSerializerKey.create("NoGravity", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Float> SCALE = IDataSerializerKey.create("Scale", IDataCodec.FLOAT, Float.valueOf(1.0f));
        public static final IDataSerializerKey<EntityTextureDescriptor> TEXTURE = IDataSerializerKey.create("Texture", EntityTextureDescriptor.CODEC, EntityTextureDescriptor.EMPTY);
        public static final IDataSerializerKey<EntityTextureDescriptor.Model> TEXTURE_MODEL = IDataSerializerKey.create("TextureModel", DataSerializers.ENTITY_TEXTURE_MODEL, EntityTextureDescriptor.Model.STEVE);
        public static final IDataSerializerKey<CompoundTag> POSE = IDataSerializerKey.create("Pose", IDataCodec.COMPOUND_TAG, new CompoundTag());
        public static final IDataSerializerKey<Rotations> POSE_HEAD = IDataSerializerKey.create("Head", EntityData.ROTATIONS_CODEC, DEFAULT_HEAD_POSE);
        public static final IDataSerializerKey<Rotations> POSE_BODY = IDataSerializerKey.create("Body", EntityData.ROTATIONS_CODEC, DEFAULT_BODY_POSE);
        public static final IDataSerializerKey<Rotations> POSE_LEFT_ARM = IDataSerializerKey.create("LeftArm", EntityData.ROTATIONS_CODEC, DEFAULT_LEFT_ARM_POSE);
        public static final IDataSerializerKey<Rotations> POSE_RIGHT_ARM = IDataSerializerKey.create("RightArm", EntityData.ROTATIONS_CODEC, DEFAULT_RIGHT_ARM_POSE);
        public static final IDataSerializerKey<Rotations> POSE_LEFT_LEG = IDataSerializerKey.create("LeftLeg", EntityData.ROTATIONS_CODEC, DEFAULT_LEFT_LEG_POSE);
        public static final IDataSerializerKey<Rotations> POSE_RIGHT_LEG = IDataSerializerKey.create("RightLeg", EntityData.ROTATIONS_CODEC, DEFAULT_RIGHT_LEG_POSE);

        private CodingKeys() {
        }
    }

    public static class EntityData {
        private static final IDataCodec<Rotations> ROTATIONS_CODEC = IDataCodec.FLOAT.listOf().xmap(it -> new Rotations(((Float)it.get(0)).floatValue(), ((Float)it.get(1)).floatValue(), ((Float)it.get(2)).floatValue()), it -> Collections.newList(Float.valueOf(it.m_123156_()), Float.valueOf(it.m_123157_()), Float.valueOf(it.m_123158_())));
        private final TagSerializer serializer;

        public EntityData() {
            this.serializer = new TagSerializer();
        }

        public EntityData(CompoundTag tag) {
            this.serializer = new TagSerializer(tag);
        }

        private static Rotations mirror(Rotations rot) {
            return new Rotations(rot.m_123156_(), -rot.m_123157_(), -rot.m_123158_());
        }

        public void setScale(float scale) {
            this.serializer.write(CodingKeys.SCALE, Float.valueOf(scale));
        }

        public float scale() {
            return this.serializer.read(CodingKeys.SCALE).floatValue();
        }

        public void setTexture(EntityTextureDescriptor texture) {
            this.serializer.write(CodingKeys.TEXTURE, texture);
        }

        public EntityTextureDescriptor texture() {
            return this.serializer.read(CodingKeys.TEXTURE);
        }

        public boolean isSmall() {
            return this.serializer.read(CodingKeys.IS_SMALL);
        }

        public CompoundTag entityTag() {
            CompoundTag entityTag = this.serializer.tag().m_6426_();
            if (!entityTag.m_128456_()) {
                entityTag.m_128359_("id", ModEntityTypes.MANNEQUIN.registryName().toString());
            }
            return entityTag;
        }

        public ItemStack itemStack() {
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.MANNEQUIN.get());
            CompoundTag entityTag = this.entityTag();
            if (!entityTag.m_128456_()) {
                ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get(), entityTag);
            }
            return itemStack;
        }
    }
}

