/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemHandler;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LinkingToolItem
extends FlavouredItem
implements IItemHandler,
IItemPropertiesProvider {
    public LinkingToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> {
            if (ComponentAPI.has(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get())) {
                return 0.0f;
            }
            return 1.0f;
        });
    }

    @Override
    public InteractionResult useOnFirst(ItemStack itemStack, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (level.m_5776_() || player == null) {
            return InteractionResult.SUCCESS;
        }
        GlobalPos linkedPos = (GlobalPos)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get());
        SkinnableBlockEntity blockEntity = this.getTitleEntity(level, context.m_8083_());
        if (blockEntity != null && player.m_36341_()) {
            blockEntity.setLinkedPos(null);
            SystemMessageProvider.sendSystemMessage(player, (Component)TranslatableProvider.translatable(Component.class, "inventory.armourers_workshop.linking-tool.clear", new Object[0]));
            return InteractionResult.SUCCESS;
        }
        if (linkedPos != null) {
            if (Objects.equals(level.m_46472_(), linkedPos.m_122640_())) {
                int maxDistance = ModConfig.Common.maxLinkDistance;
                if (maxDistance > 0 && !context.m_8083_().m_123314_((Vec3i)linkedPos.m_122646_(), (double)maxDistance + 0.5)) {
                    SystemMessageProvider.sendSystemMessage(player, (Component)TranslatableProvider.translatable(Component.class, "inventory.armourers_workshop.linking-tool.targetTooFar", new Object[0]));
                    return InteractionResult.FAIL;
                }
            } else if (!ModConfig.Common.enableLinkDimensional) {
                SystemMessageProvider.sendSystemMessage(player, (Component)TranslatableProvider.translatable(Component.class, "inventory.armourers_workshop.linking-tool.targetWrongDimensions", new Object[0]));
                return InteractionResult.FAIL;
            }
            ComponentAPI.remove(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get());
            if (blockEntity != null) {
                blockEntity.setLinkedPos(linkedPos);
                SystemMessageProvider.sendSystemMessage(player, (Component)TranslatableProvider.translatable(Component.class, "inventory.armourers_workshop.linking-tool.finish", new Object[0]));
                return InteractionResult.SUCCESS;
            }
            SystemMessageProvider.sendSystemMessage(player, (Component)TranslatableProvider.translatable(Component.class, "inventory.armourers_workshop.linking-tool.fail", new Object[0]));
            return InteractionResult.SUCCESS;
        }
        if (blockEntity != null) {
            SystemMessageProvider.sendSystemMessage(player, (Component)TranslatableProvider.translatable(Component.class, "inventory.armourers_workshop.linking-tool.linkedToSkinnable", new Object[0]));
            return InteractionResult.FAIL;
        }
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get(), GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)context.m_8083_()));
        SystemMessageProvider.sendSystemMessage(player, (Component)TranslatableProvider.translatable(Component.class, "inventory.armourers_workshop.linking-tool.start", new Object[0]));
        return InteractionResult.SUCCESS;
    }

    private SkinnableBlockEntity getTitleEntity(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            return (SkinnableBlockEntity)blockEntity;
        }
        return null;
    }
}

