/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import moe.plushie.armourers_workshop.api.core.math.IVector2i;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class OpenVector2i
implements IVector2i {
    public static final OpenVector2i ZERO = new OpenVector2i(0, 0);
    public int x;
    public int y;

    public OpenVector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public OpenVector2i(double x, double y) {
        this(OpenMath.floori(x), OpenMath.floori(y));
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenVector2i)) {
            return false;
        }
        OpenVector2i that = (OpenVector2i)o;
        return this.x == that.x && this.y == that.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return OpenMath.format("(%d %d)", this.x, this.y);
    }
}

