/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class HologramProjectorMenu
extends AbstractBlockEntityMenu<HologramProjectorBlockEntity> {
    private final Inventory playerInventory;
    private final Container inventory;
    private int group;

    public HologramProjectorMenu(MenuType<?> menuType, Block block, int containerId, Inventory playerInventory, IGlobalPos worldPos) {
        super((MenuType)menuType, block, containerId, worldPos);
        this.playerInventory = playerInventory;
        this.inventory = ((HologramProjectorBlockEntity)this.blockEntity).getInventory();
        this.reload(0, 0, 240, 240);
    }

    public void reload(int inventoryX, int inventoryY, int width, int height) {
        this.f_38839_.clear();
        this.addPlayerSlots((Container)this.playerInventory, inventoryX + 8, inventoryY + 16, this.visibleSlotBuilder(this::shouldRenderInventory));
        if (this.inventory != null) {
            this.addSkinSlots(this.inventory, 1, width, height);
        }
    }

    public int group() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        return this.quickMoveStack(player, index, this.f_38839_.size());
    }

    public boolean shouldRenderInventory() {
        return this.group() == 1;
    }

    protected void addSkinSlots(Container inventory, int group, int width, int height) {
        int size = inventory.m_6643_();
        int slotsX = (width - 176) / 2 + 80;
        int slotsY = 16;
        for (int i = 0; i < size; ++i) {
            int tx = slotsX + i * 19;
            this.m_38897_(new GroupSlot(inventory, group, i, tx, slotsY));
        }
    }

    public final class GroupSlot
    extends Slot {
        private final int group;

        public GroupSlot(Container inventory, int group, int index, int x, int y) {
            super(inventory, index, x, y);
            this.group = group;
        }

        public boolean m_6659_() {
            return HologramProjectorMenu.this.group() == this.group;
        }
    }
}

