/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.data.GenericProperties;
import moe.plushie.armourers_workshop.core.data.GenericProperty;
import moe.plushie.armourers_workshop.core.data.GenericValue;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateHologramProjectorPacket
extends CustomPacket {
    private final BlockPos pos;
    private final GenericValue<HologramProjectorBlockEntity, ?> fieldValue;

    public UpdateHologramProjectorPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.fieldValue = Field.TYPE.read(buffer);
    }

    public UpdateHologramProjectorPacket(HologramProjectorBlockEntity entity, GenericValue<HologramProjectorBlockEntity, ?> fieldValue) {
        this.pos = entity.m_58899_();
        this.fieldValue = fieldValue;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        this.fieldValue.write(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        BlockEntity entity = player.m_183503_().m_7702_(this.pos);
        if (entity instanceof HologramProjectorBlockEntity) {
            HologramProjectorBlockEntity blockEntity = (HologramProjectorBlockEntity)entity;
            this.fieldValue.apply(blockEntity);
        }
    }

    public static final class Field<T>
    extends GenericProperty<HologramProjectorBlockEntity, T> {
        private static final GenericProperties<HologramProjectorBlockEntity> TYPE = GenericProperties.of(HologramProjectorBlockEntity.class, UpdateHologramProjectorPacket::new);
        public static final Field<Integer> POWER_MODE = Field.create(HologramProjectorBlockEntity::powerMode, HologramProjectorBlockEntity::setPowerMode, DataSerializers.INT);
        public static final Field<Boolean> IS_GLOWING = Field.create(HologramProjectorBlockEntity::isGlowing, HologramProjectorBlockEntity::setGlowing, DataSerializers.BOOLEAN);
        public static final Field<Boolean> SHOWS_ROTATION_POINT = Field.create(HologramProjectorBlockEntity::shouldShowRotationPoint, HologramProjectorBlockEntity::setShowRotationPoint, DataSerializers.BOOLEAN);
        public static final Field<OpenVector3f> OFFSET = Field.create(HologramProjectorBlockEntity::getModelOffset, HologramProjectorBlockEntity::setModelOffset, DataSerializers.VECTOR_3F);
        public static final Field<OpenVector3f> ANGLE = Field.create(HologramProjectorBlockEntity::getModelAngle, HologramProjectorBlockEntity::setModelAngle, DataSerializers.VECTOR_3F);
        public static final Field<OpenVector3f> ROTATION_OFFSET = Field.create(HologramProjectorBlockEntity::getRotationOffset, HologramProjectorBlockEntity::setRotationOffset, DataSerializers.VECTOR_3F);
        public static final Field<OpenVector3f> ROTATION_SPEED = Field.create(HologramProjectorBlockEntity::getRotationSpeed, HologramProjectorBlockEntity::setRotationSpeed, DataSerializers.VECTOR_3F);

        private static <T> Field<T> create(Function<HologramProjectorBlockEntity, T> supplier, BiConsumer<HologramProjectorBlockEntity, T> applier, IEntitySerializer<T> dataSerializer) {
            return TYPE.create(dataSerializer).setter(applier).getter(supplier).build(Field::new);
        }
    }
}

