/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.LivingEntity.EquipmentItemProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix1621;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.EffectSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.ItemSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.LivingEntitySelector;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ContextSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EffectSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EntitySelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ItemSelectorImpl;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LivingEntitySelectorImpl<T extends LivingEntity>
extends EntitySelectorImpl<T>
implements LivingEntitySelector {
    private static final Map<String, Optional<OpenEquipmentSlot>> NAMED_SLOTS = new ConcurrentHashMap<String, Optional<OpenEquipmentSlot>>();
    private static final Map<String, OpenEquipmentSlot> FIXED_SLOTS = Collections.immutableMap(it -> {
        it.put((Object)"chest", (Object)OpenEquipmentSlot.CHEST);
        it.put((Object)"feet", (Object)OpenEquipmentSlot.FEET);
        it.put((Object)"head", (Object)OpenEquipmentSlot.HEAD);
        it.put((Object)"legs", (Object)OpenEquipmentSlot.LEGS);
        it.put((Object)"mainhand", (Object)OpenEquipmentSlot.MAINHAND);
        it.put((Object)"offhand", (Object)OpenEquipmentSlot.OFFHAND);
        it.put((Object)"body", (Object)OpenEquipmentSlot.BODY);
    });
    private final ItemSelectorImpl itemSelector = new ItemSelectorImpl();
    private final EffectSelectorImpl effectSelector = new EffectSelectorImpl();

    @Override
    public LivingEntitySelectorImpl<T> apply(T entity, ContextSelectorImpl context) {
        super.apply(entity, context);
        return this;
    }

    @Override
    public double bodyYaw() {
        return MathHelper.lerp(this.partialTick(), ((LivingEntity)this.entity).f_19860_, ((LivingEntity)this.entity).m_146909_());
    }

    @Override
    public double bodyPitch() {
        return MathHelper.wrapDegrees(MathHelper.lerp(this.partialTick(), ((LivingEntity)this.entity).f_19859_, ((LivingEntity)this.entity).m_146908_()));
    }

    @Override
    public double health() {
        return ((LivingEntity)this.entity).m_21223_();
    }

    @Override
    public double maxHealth() {
        return ((LivingEntity)this.entity).m_21233_();
    }

    @Override
    public double armorValue() {
        return ((LivingEntity)this.entity).m_21230_();
    }

    @Override
    public double hurtTime() {
        return ((LivingEntity)this.entity).f_20916_;
    }

    @Override
    public boolean isDeadOrDying() {
        return ((LivingEntity)this.entity).m_21224_();
    }

    @Override
    public boolean isEating() {
        return ((LivingEntity)this.entity).m_21211_().m_41780_() == UseAnim.EAT;
    }

    @Override
    public boolean isSleeping() {
        return ((LivingEntity)this.entity).m_5803_();
    }

    @Override
    public boolean isUsingItem() {
        return ((LivingEntity)this.entity).m_6117_();
    }

    @Override
    public boolean isAutoSpinAttack() {
        return ((LivingEntity)this.entity).m_21209_();
    }

    @Override
    public boolean isOnClimbable() {
        return ((LivingEntity)this.entity).m_6147_();
    }

    @Override
    public double usingItemDuration() {
        return (double)((LivingEntity)this.entity).m_21252_() / 20.0;
    }

    @Override
    public double usingItemMaxDuration() {
        ItemStack item = ((LivingEntity)this.entity).m_21211_();
        if (!item.m_41619_()) {
            return Fix1621.getUseDuration(item, (LivingEntity)this.entity) / 20.0;
        }
        return 0.0;
    }

    @Override
    public double usingItemRemainingDuration() {
        return (double)((LivingEntity)this.entity).m_21212_() / 20.0;
    }

    @Override
    public int arrowCount() {
        return ((LivingEntity)this.entity).m_21234_();
    }

    @Override
    public int stingerCount() {
        return ((LivingEntity)this.entity).m_21235_();
    }

    @Override
    public double attributeValueByName(String name) {
        return AbstractRegistryManager.getAttribute((LivingEntity)this.entity, name);
    }

    @Override
    @Nullable
    public EffectSelector effectByName(String name) {
        MobEffectInstance effect = AbstractRegistryManager.getEffect((LivingEntity)this.entity, name);
        if (effect != null) {
            return this.effectSelector.apply(effect);
        }
        return null;
    }

    @Override
    @Nullable
    public ItemSelector equippedItemBySlot(String name) {
        Optional slot = NAMED_SLOTS.computeIfAbsent(name, LivingEntitySelectorImpl::findSlot);
        ItemStack itemStack = slot.map(it -> EquipmentItemProvider.getItemBySlot((LivingEntity)this.entity, it)).orElse(ItemStack.f_41583_);
        if (!itemStack.m_41619_()) {
            return this.itemSelector.apply(itemStack);
        }
        return null;
    }

    @Override
    public int equipmentCount() {
        int count = 0;
        for (OpenEquipmentSlot slot : OpenEquipmentSlot.values()) {
            ItemStack stack;
            if (slot == OpenEquipmentSlot.MAINHAND || slot == OpenEquipmentSlot.OFFHAND || (stack = EquipmentItemProvider.getItemBySlot((LivingEntity)this.entity, slot)).m_41619_()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int lastClimbableFacing() {
        Level level = ((LivingEntity)this.entity).m_183503_();
        if (level == null) {
            return 0;
        }
        Optional climbablePos = ((LivingEntity)this.entity).m_21227_();
        if (!climbablePos.isPresent()) {
            return 0;
        }
        BlockState blockState = level.m_8055_((BlockPos)climbablePos.get());
        Optional facing = blockState.m_61145_((Property)HorizontalDirectionalBlock.f_54117_);
        return facing.map(Direction::m_122416_).orElse(0);
    }

    private static Optional<OpenEquipmentSlot> findSlot(String name) {
        return Optional.ofNullable(FIXED_SLOTS.get(name.toLowerCase()));
    }
}

