/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.document;

import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import net.minecraft.nbt.CompoundTag;

public class SkinDocumentSettings
implements IDataSerializable.Immutable {
    public static IDataCodec<SkinDocumentSettings> CODEC = IDataCodec.COMPOUND_TAG.serializer(SkinDocumentSettings::new);
    private float scale = 1.0f;
    private boolean showsOrigin = true;
    private boolean showsHelperModel = true;
    private OpenItemTransforms itemTransforms;
    private SkinDocumentListener listener;

    public SkinDocumentSettings() {
    }

    public SkinDocumentSettings(IDataSerializer serializer) {
        this.scale = serializer.read(CodingKeys.SCALE).floatValue();
        this.showsHelperModel = serializer.read(CodingKeys.HELPER_MODEL);
        this.showsOrigin = serializer.read(CodingKeys.ORIGIN);
        this.itemTransforms = serializer.read(CodingKeys.ITEM_TRANSFORMS);
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.SCALE, Float.valueOf(this.scale));
        serializer.write(CodingKeys.HELPER_MODEL, this.showsHelperModel);
        serializer.write(CodingKeys.ORIGIN, this.showsOrigin);
        serializer.write(CodingKeys.ITEM_TRANSFORMS, this.itemTransforms);
    }

    public void deserialize(IDataSerializer serializer) {
        OpenItemTransforms newItemTransforms;
        Boolean newOrigin;
        Boolean newHelperModel;
        Float newScale = serializer.read(CodingKeys.INC_SCALE);
        if (newScale != null) {
            this.scale = newScale.floatValue();
        }
        if ((newHelperModel = serializer.read(CodingKeys.INC_HELPER_MODEL)) != null) {
            this.showsHelperModel = newHelperModel;
        }
        if ((newOrigin = serializer.read(CodingKeys.INC_ORIGIN)) != null) {
            this.showsHelperModel = newOrigin;
        }
        if ((newItemTransforms = serializer.read(CodingKeys.INC_ITEM_TRANSFORMS)) != null) {
            this.itemTransforms = newItemTransforms;
        }
    }

    public void applyChanges(CompoundTag tag) {
        this.deserialize(new TagSerializer(tag));
    }

    public void setShowsHelperModel(boolean value) {
        this.showsHelperModel = value;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_HELPER_MODEL, value);
            this.listener.documentDidChangeSettings(builder.tag());
        }
    }

    public boolean showsHelperModel() {
        return this.showsHelperModel;
    }

    public void setShowsOrigin(boolean value) {
        this.showsOrigin = value;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_ORIGIN, value);
            this.listener.documentDidChangeSettings(builder.tag());
        }
    }

    public boolean showsOrigin() {
        return this.showsOrigin;
    }

    public void setItemTransforms(OpenItemTransforms itemTransforms) {
        this.itemTransforms = itemTransforms;
        if (this.listener != null) {
            TagSerializer builder = new TagSerializer();
            builder.write(CodingKeys.INC_ITEM_TRANSFORMS, itemTransforms);
            this.listener.documentDidChangeSettings(builder.tag());
        }
    }

    public OpenItemTransforms itemTransforms() {
        return this.itemTransforms;
    }

    protected void setListener(SkinDocumentListener listener) {
        this.listener = listener;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<Float> SCALE = IDataSerializerKey.create("Scale", IDataCodec.FLOAT, Float.valueOf(1.0f));
        public static final IDataSerializerKey<Boolean> ORIGIN = IDataSerializerKey.create("Origin", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> HELPER_MODEL = IDataSerializerKey.create("HelperModel", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<OpenItemTransforms> ITEM_TRANSFORMS = IDataSerializerKey.create("ItemTransforms", OpenItemTransforms.CODEC, null);
        public static final IDataSerializerKey<Float> INC_SCALE = IDataSerializerKey.create("Scale", IDataCodec.FLOAT, null);
        public static final IDataSerializerKey<Boolean> INC_ORIGIN = IDataSerializerKey.create("Origin", IDataCodec.BOOL, null);
        public static final IDataSerializerKey<Boolean> INC_HELPER_MODEL = IDataSerializerKey.create("HelperModel", IDataCodec.BOOL, null);
        public static final IDataSerializerKey<OpenItemTransforms> INC_ITEM_TRANSFORMS = IDataSerializerKey.create("ItemTransforms", OpenItemTransforms.CODEC, null);

        private CodingKeys() {
        }
    }
}

