/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.Collection;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanOverride;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class SkinUtils {
    public static Collection<String> getItemOverrides(SkinPartType partType) {
        ICanOverride override = Objects.safeCast(partType, ICanOverride.class);
        if (override != null) {
            return override.itemOverrides();
        }
        return Collections.emptyList();
    }

    public static boolean shouldKeepWardrobe(Player entity) {
        if (entity.m_5833_()) {
            return true;
        }
        int keep = ModConfig.Common.prefersWardrobeDropOnDeath;
        if (keep == 1) {
            return true;
        }
        if (keep == 2) {
            return false;
        }
        return entity.m_183503_().m_46469_().m_46207_(GameRules.f_46133_);
    }

    public static void dropAllIfNeeded(Player player) {
        if (SkinUtils.shouldKeepWardrobe(player)) {
            return;
        }
        SkinWardrobe oldWardrobe = SkinWardrobe.of((Entity)player);
        if (oldWardrobe != null) {
            oldWardrobe.dropAll(arg_0 -> ((Player)player).m_19983_(arg_0));
            oldWardrobe.broadcast();
        }
    }

    public static <T extends Entity> Consumer<T> appendSkinIntoEntity(Consumer<T> consumer, ServerLevel serverLevel, ItemStack itemStack, @Nullable Player player) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return consumer;
        }
        return consumer.andThen(entity -> {
            if (!(entity instanceof Boat) && !(entity instanceof AbstractMinecart)) {
                return;
            }
            SkinWardrobe wardrobe = SkinWardrobe.of(entity);
            if (wardrobe != null) {
                wardrobe.setItem(SkinSlotType.ANY, 0, descriptor.asItemStack());
                wardrobe.broadcast();
            }
        });
    }

    public static <T extends Entity> Consumer<ItemStack> appendSkinIntoItemStack(Consumer<ItemStack> consumer, T entity) {
        if (!(entity instanceof Boat) && !(entity instanceof AbstractMinecart)) {
            return consumer;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe == null) {
            return consumer;
        }
        ItemStack itemStack1 = wardrobe.getItem(SkinSlotType.ANY, 0);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack1);
        if (descriptor.isEmpty()) {
            return consumer;
        }
        return consumer.andThen(itemStack -> ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.SKIN.get(), descriptor));
    }

    public static void copySkinWardrobe(Entity from, Entity to) {
        SkinWardrobe oldWardrobe = SkinWardrobe.of(from);
        SkinWardrobe newWardrobe = SkinWardrobe.of(to);
        if (newWardrobe != null && oldWardrobe != null) {
            TagSerializer serializer = new TagSerializer(new CompoundTag(), to);
            oldWardrobe.serialize(serializer);
            newWardrobe.deserialize(serializer);
            if (!to.m_183503_().m_5776_()) {
                newWardrobe.broadcast();
            }
        }
    }

    public static void copySkinFromOwner(Entity entity) {
        Projectile projectile = Objects.safeCast(entity, Projectile.class);
        if (projectile == null) {
            return;
        }
        Entity owner = projectile.m_37282_();
        if (entity instanceof ThrownTrident) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.TRIDENT, 0, SkinSlotType.ANY, 0);
            return;
        }
        if (entity instanceof AbstractArrow) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.BOW, 0, SkinSlotType.ANY, 0);
            return;
        }
        if (entity instanceof FishingHook && owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            ItemStack itemStack = livingEntity.m_21205_();
            if (!itemStack.m_150930_(Items.f_42523_)) {
                itemStack = livingEntity.m_21206_();
            }
            SkinUtils.copySkin(entity, itemStack, SkinSlotType.ANY, 0);
            return;
        }
    }

    public static void copySkin(Entity src, Entity dest, SkinSlotType fromSlotType, int fromIndex, SkinSlotType toSlotType, int toIndex) {
        ItemStack itemStack = SkinUtils.getSkin(src, fromSlotType, fromIndex);
        if (itemStack.m_41619_()) {
            return;
        }
        SkinUtils.copySkin(dest, itemStack, toSlotType, toIndex);
    }

    public static void copySkin(Entity dest, ItemStack itemStack, SkinSlotType toSlotType, int toIndex) {
        SkinWardrobe wardrobe = SkinWardrobe.of(dest);
        if (wardrobe != null) {
            wardrobe.setItem(toSlotType, toIndex, itemStack.m_41777_());
            wardrobe.broadcast();
        }
    }

    public static ItemStack getSkin(Entity entity, SkinSlotType slotType, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            itemStack = SkinUtils.getUsingItem(livingEntity);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (Objects.equals(slotType.skinType(), descriptor.type())) {
            return itemStack;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null) {
            ItemStack itemStack1 = wardrobe.getItem(slotType, index);
            descriptor = SkinDescriptor.of(itemStack1);
            if (Objects.equals(slotType.skinType(), descriptor.type())) {
                return itemStack1;
            }
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getUsingItem(LivingEntity entity) {
        ItemStack itemStack = entity.m_21211_();
        if (!itemStack.m_41619_()) {
            return itemStack;
        }
        itemStack = entity.m_21205_();
        if (itemStack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemStack)) {
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    private static int getSkinIndex(String partIndexProp, Skin skin, int partIndex) {
        String[] split = partIndexProp.split(":");
        for (int i = 0; i < split.length; ++i) {
            int count = Integer.parseInt(split[i]);
            if (partIndex >= count) continue;
            return i;
        }
        return -1;
    }

    public static VoxelShape apply(VoxelShape shape, OpenMatrix4f matrix) {
        float minX = (float)shape.m_83288_(Direction.Axis.X);
        float minY = (float)shape.m_83288_(Direction.Axis.Y);
        float minZ = (float)shape.m_83288_(Direction.Axis.Z);
        float maxX = (float)shape.m_83297_(Direction.Axis.X);
        float maxY = (float)shape.m_83297_(Direction.Axis.Y);
        float maxZ = (float)shape.m_83297_(Direction.Axis.Z);
        OpenVector4f[] points = new OpenVector4f[]{new OpenVector4f(minX, minY, minZ, 1.0f), new OpenVector4f(maxX, minY, minZ, 1.0f), new OpenVector4f(maxX, maxY, minZ, 1.0f), new OpenVector4f(minX, maxY, minZ, 1.0f), new OpenVector4f(minX, minY, maxZ, 1.0f), new OpenVector4f(maxX, minY, maxZ, 1.0f), new OpenVector4f(maxX, maxY, maxZ, 1.0f), new OpenVector4f(minX, maxY, maxZ, 1.0f)};
        boolean isReset = false;
        for (OpenVector4f point : points) {
            point.transform(matrix);
            if (isReset) {
                minX = Math.min(minX, point.x());
                minY = Math.min(minY, point.y());
                minZ = Math.min(minZ, point.z());
                maxX = Math.max(maxX, point.x());
                maxY = Math.max(maxY, point.y());
                maxZ = Math.max(maxZ, point.z());
                continue;
            }
            minX = point.x();
            minY = point.y();
            minZ = point.z();
            maxX = point.x();
            maxY = point.y();
            maxZ = point.z();
            isReset = true;
        }
        return Shapes.m_83048_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private static float[][][] reorder(float[][][] values, int ... indexes) {
        float[][][] newValues = new float[values.length][][];
        for (int i = 0; i < values.length; ++i) {
            float[][] faces = values[i];
            float[][] newFaces = new float[faces.length][];
            for (int j = 0; j < faces.length; ++j) {
                if (j < indexes.length) {
                    newFaces[indexes[j]] = faces[j];
                    continue;
                }
                newFaces[j] = faces[j];
            }
            newValues[i] = newFaces;
        }
        return newValues;
    }
}

