/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractModelViewStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.OutlineColor;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedFirstPersonArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.model.EmbeddedItemModel;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntitySlot;
import moe.plushie.armourers_workshop.core.client.other.FindableSkinManager;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderHelper;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderMode;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.FallbackEntityRenderPatch;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.LivingEntityRenderPatch;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
public class ClientWardrobeHandler {
    private static Runnable INVENTORY_RENDER_POST_EVENT = null;
    public static ItemStack RENDERING_GUI_ITEM = null;
    public static final float SCALE = 0.0625f;

    public static void init() {
    }

    public static void tick(Entity entity) {
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null) {
            renderData.tick(entity);
        }
        for (Entity passenger : entity.m_20197_()) {
            ClientWardrobeHandler.tick(passenger);
        }
    }

    public static void startRenderGuiItem(ItemStack itemStack) {
        RENDERING_GUI_ITEM = itemStack;
    }

    public static void endRenderGuiItem(ItemStack itemStack) {
        RENDERING_GUI_ITEM = null;
    }

    public static void onRenderSpecificHand(LivingEntity entity, float partialTicks, int packedLight, OpenItemDisplayContext displayContext, PoseStack poseStackIn, MultiBufferSource buffersIn, Runnable cancelHandler) {
        EntityRenderData renderData = EntityRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        List<EntitySlot> renderingTasks = renderData.armorSkins();
        if (renderingTasks.isEmpty()) {
            return;
        }
        IPoseStack poseStack = AbstractPoseStack.wrap(poseStackIn);
        AbstractBufferSource bufferSource = AbstractBufferSource.wrap(buffersIn);
        BakedFirstPersonArmature armature = BakedFirstPersonArmature.defaultBy(displayContext);
        poseStack.pushPose();
        poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
        boolean overrideHandModel = renderData.overriddenManager().overrideHandModel(displayContext);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, partialTicks, displayContext);
        context.setOverlay(OverlayTexture.f_118083_);
        context.setLightmap(packedLight);
        context.setPartialTicks(partialTicks);
        context.setAnimationTicks(TickUtils.animationTicks());
        context.setPoseStack(poseStack);
        context.setBufferSource(bufferSource);
        context.setModelViewStack(AbstractModelViewStack.getInstance());
        context.setOutlineColor(0);
        int count = ClientWardrobeHandler.render((Entity)entity, armature, context, renderData.armorSkins());
        if (count != 0 && overrideHandModel && !ModDebugger.handOverride) {
            cancelHandler.run();
        }
        context.release();
        poseStack.popPose();
    }

    public static void onRenderEntityPre(Entity entity, float partialTicks, PoseStack poseStackIn, MultiBufferSource bufferSourceIn, int packedLight, EntityRenderer<?> entityRenderer) {
        FallbackEntityRenderPatch.activate(entity, partialTicks, packedLight, poseStackIn, entityRenderer, null);
    }

    public static void onRenderEntity(Entity entity, float partialTicks, PoseStack poseStackIn, MultiBufferSource bufferSourceIn, int packedLight, EntityRenderer<?> entityRenderer) {
        FallbackEntityRenderPatch.apply(entity, poseStackIn, bufferSourceIn, null);
    }

    public static void onRenderEntityPost(Entity entity, float partialTicks, PoseStack poseStackIn, MultiBufferSource bufferSourceIn, int packedLight, EntityRenderer<?> entityRenderer) {
        FallbackEntityRenderPatch.deactivate(entity, null);
    }

    public static void onRenderLivingEntityPre(LivingEntity entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource bufferSourceIn, LivingEntityRenderer<?, ?> entityRenderer) {
        LivingEntityRenderPatch.activate(entity, partialTicks, packedLight, poseStackIn, entityRenderer, null);
    }

    public static void onRenderLivingEntity(LivingEntity entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource bufferSourceIn, LivingEntityRenderer<?, ?> entityRenderer) {
        LivingEntityRenderPatch.apply(entity, poseStackIn, bufferSourceIn, null);
    }

    public static void onRenderLivingEntityPost(LivingEntity entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource bufferSourceIn, LivingEntityRenderer<?, ?> entityRenderer) {
        LivingEntityRenderPatch.deactivate(entity, null);
    }

    public static EmbeddedItemModel getEmbeddedItemModel(ItemStack itemStack, @Nullable LivingEntity entity, @Nullable Level level, BakedModel bakedModel) {
        Iterator<EntitySlot> iterator;
        EntityRenderData renderData;
        if (RENDERING_GUI_ITEM != itemStack && (renderData = EntityRenderData.of((Entity)entity)) != null && (iterator = renderData.getItemSkins(itemStack, entity instanceof MannequinEntity).iterator()).hasNext()) {
            EntitySlot entry = iterator.next();
            return EmbeddedItemModel.fromWardrobe(entity, level, entry);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            descriptor = FindableSkinManager.getInstance().getSkin(bakedModel);
            if (!descriptor.isEmpty()) {
                return EmbeddedItemModel.fromComponent(entity, level, descriptor, itemStack);
            }
            return null;
        }
        if (itemStack.m_150930_((Item)ModItems.SKIN.get())) {
            return EmbeddedItemModel.fromSelf(entity, level, descriptor, itemStack);
        }
        if (descriptor.options().embeddedItemRenderer() != 0) {
            if (descriptor.options().embeddedItemRenderer() == 2) {
                return EmbeddedItemModel.fromComponent(entity, level, descriptor, itemStack);
            }
            return null;
        }
        if (ModConfig.enableEmbeddedSkinRenderer() || descriptor.type() == SkinTypes.ITEM) {
            return EmbeddedItemModel.fromComponent(entity, level, descriptor, itemStack);
        }
        return null;
    }

    public static void renderEmbeddedItemModel(ItemStack itemStack, OpenItemDisplayContext displayContext, BakedModel bakedModel, EmbeddedItemModel itemModel, int packedLight, int overlay, boolean leftHandHackery, PoseStack poseStackIn, MultiBufferSource buffersIn, CallbackInfo callback) {
        if (SkinRenderMode.inGUI() && !bakedModel.m_7547_()) {
            Lighting.m_84931_();
        }
        int counter = 0;
        switch (displayContext) {
            case GUI: 
            case GROUND: 
            case FIXED: {
                counter = ClientWardrobeHandler._renderEmbeddedSkinInBox(itemStack, displayContext, bakedModel, itemModel, packedLight, overlay, 0, poseStackIn, buffersIn);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                EntitySlot sourceSlot;
                int outlineColor = 0;
                LivingEntity entity = itemModel.entity();
                if (entity != null && displayContext.isThirdPerson()) {
                    outlineColor = OutlineColor.getOutlineColor((Entity)entity);
                }
                if ((sourceSlot = itemModel.sourceSlot()) == null) {
                    if (itemModel.shouldRenderInBox()) {
                        counter = ClientWardrobeHandler._renderEmbeddedSkinInBox(itemStack, displayContext, bakedModel, itemModel, packedLight, overlay, outlineColor, poseStackIn, buffersIn);
                        break;
                    }
                    counter = ClientWardrobeHandler._renderEmbeddedSkin(itemStack, displayContext, bakedModel, itemModel, packedLight, overlay, outlineColor, poseStackIn, buffersIn);
                    break;
                }
                if (sourceSlot.skinType() == SkinTypes.ITEM_BACKPACK && sourceSlot.slotType() == EntitySlot.Type.IN_WARDROBE) {
                    return;
                }
                EntityRenderData renderData = EntityRenderData.of((Entity)entity);
                if (renderData == null) break;
                IPoseStack poseStack = AbstractPoseStack.wrap(poseStackIn);
                AbstractBufferSource bufferSource = AbstractBufferSource.wrap(buffersIn);
                BakedArmature armature = BakedArmature.defaultBy(Armatures.ANY);
                poseStack.pushPose();
                poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
                SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, 0.0f, displayContext);
                context.setOverlay(OverlayTexture.f_118083_);
                context.setLightmap(packedLight);
                context.setPartialTicks(0.0f);
                context.setAnimationTicks(TickUtils.animationTicks());
                context.setPoseStack(poseStack);
                context.setBufferSource(bufferSource);
                context.setModelViewStack(AbstractModelViewStack.getInstance());
                context.setOutlineColor(outlineColor);
                context.setItemSource(SkinItemSource.create(800.0f, itemStack, displayContext, itemModel.properties()));
                context.setUseItemTransforms(true);
                counter = ClientWardrobeHandler.render((Entity)entity, armature, context, Collections.singleton(sourceSlot));
                context.release();
                poseStack.popPose();
                break;
            }
        }
        if (SkinRenderMode.inGUI() && !bakedModel.m_7547_()) {
            Lighting.m_84930_();
        }
        if (counter != 0 && !ModDebugger.itemOverride) {
            callback.cancel();
        }
    }

    private static int _renderEmbeddedSkinInBox(ItemStack itemStack, OpenItemDisplayContext displayContext, BakedModel bakedModel, EmbeddedItemModel itemModel, int packedLight, int overlay, int outlineColor, PoseStack poseStackIn, MultiBufferSource buffersIn) {
        int count = 0;
        SkinDescriptor descriptor = itemModel.sourceSkin();
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(TicketManager.INVENTORY.get(descriptor));
        if (bakedSkin == null) {
            return count;
        }
        IPoseStack poseStack = AbstractPoseStack.wrap(poseStackIn);
        AbstractBufferSource buffers = AbstractBufferSource.wrap(buffersIn);
        OpenVector3f rotation = OpenVector3f.ZERO;
        OpenVector3f scale = OpenVector3f.ONE;
        poseStack.pushPose();
        SkinItemSource itemSource = SkinItemSource.create(descriptor.sharedItemStack());
        itemSource.setScale(scale);
        itemSource.setRotation(rotation);
        itemSource.setDisplayContext(displayContext);
        SkinPaintScheme scheme = descriptor.paintScheme();
        count = ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, 0.0f, packedLight, outlineColor, itemSource, poseStack, buffers);
        poseStack.popPose();
        return count;
    }

    private static int _renderEmbeddedSkin(ItemStack itemStack, OpenItemDisplayContext displayContext, BakedModel bakedModel, EmbeddedItemModel itemModel, int packedLight, int overlay, int outlineColor, PoseStack poseStackIn, MultiBufferSource buffersIn) {
        int count = 0;
        SkinDescriptor descriptor = itemModel.sourceSkin();
        SkinRenderTesselator tesselator = SkinRenderTesselator.create(TicketManager.INVENTORY.get(descriptor));
        if (tesselator == null) {
            return count;
        }
        IPoseStack poseStack = AbstractPoseStack.wrap(poseStackIn);
        AbstractBufferSource bufferSource = AbstractBufferSource.wrap(buffersIn);
        poseStack.pushPose();
        poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
        tesselator.setRenderData(EntityRenderData.of((Entity)tesselator.mannequin()));
        tesselator.setPartialTicks(0.0f);
        tesselator.setLightmap(packedLight);
        tesselator.setPoseStack(poseStack);
        tesselator.setBufferSource(bufferSource);
        tesselator.setModelViewStack(AbstractModelViewStack.getInstance());
        tesselator.setColorScheme(descriptor.paintScheme());
        tesselator.setItemSource(SkinItemSource.create(800.0f, itemModel.sourceStack(), displayContext, itemModel.properties()));
        tesselator.setUseItemTransforms(true);
        tesselator.setDisplayBox(null);
        tesselator.setDisplayContext(displayContext);
        tesselator.setOutlineColor(outlineColor);
        count = tesselator.draw();
        poseStack.popPose();
        return count;
    }

    public static void onRenderInventoryEntityPre(LivingEntity entity, int x, int y, int scale, float mouseX, float mouseY) {
        int top;
        int left;
        int height;
        int width;
        if (!ModConfig.Client.enableEntityInInventoryClip) {
            return;
        }
        switch (scale) {
            case 20: {
                width = 32;
                height = 43;
                left = x - width / 2 + 1;
                top = y - height + 4;
                break;
            }
            case 30: {
                width = 49;
                height = 70;
                left = x - width / 2 - 1;
                top = y - height + 3;
                break;
            }
            default: {
                return;
            }
        }
        RenderSystem.addClipRect(left, top, width, height);
        INVENTORY_RENDER_POST_EVENT = RenderSystem::removeClipRect;
    }

    public static void onRenderInventoryEntityPost(LivingEntity entity) {
        if (INVENTORY_RENDER_POST_EVENT != null) {
            INVENTORY_RENDER_POST_EVENT.run();
            INVENTORY_RENDER_POST_EVENT = null;
        }
    }

    public static int render(Entity entity, BakedArmature bakedArmature, SkinRenderContext context, Iterable<EntitySlot> entries) {
        int r = 0;
        for (EntitySlot entry : entries) {
            BakedSkin bakedSkin = entry.skin();
            SkinItemSource itemSource = context.itemSource();
            ItemStack itemStack = itemSource.item();
            if (itemStack.m_41619_()) {
                itemStack = entry.itemStack();
            }
            if (itemSource == SkinItemSource.EMPTY) {
                itemSource = SkinItemSource.create(itemStack);
            }
            itemSource.setItem(itemStack);
            itemSource.setRenderPriority(entry.renderPriority());
            context.setItemSource(itemSource);
            context.setOverlay(entry.getOverrideOverlay(entity));
            bakedSkin.setupAnim(entity, bakedArmature, context);
            SkinPaintScheme paintScheme = bakedSkin.resolve(entity, entry.paintScheme());
            if (context.isUseItemTransforms()) {
                BakedItemTransform itemTransform = bakedSkin.itemTransform();
                itemTransform.apply(context.poseStack(), entity, bakedSkin, context);
            }
            SkinRenderer.render(entity, bakedArmature, bakedSkin, paintScheme, context);
            r += SkinRenderHelper.getRenderCount(bakedSkin);
        }
        return r;
    }
}

