/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraft.network.chat.Component;

public class ColorParser {
    public static final DynamicCommandExceptionType ERROR_INVALID_COLOR_FORMAT = new DynamicCommandExceptionType(obj -> TranslatableProvider.translatable(Component.class, "commands.armourers.invalidColorFormat", obj));
    private static final IntegerArgumentType INTEGER_ARGUMENT = IntegerArgumentType.integer((int)0, (int)255);
    private static final List<String> DEFAULT_COLORS = Collections.newList("#ffffff", "0xffffff", "255,255,255");
    private static final Map<String, SkinPaintType> PAINT_TYPES = Collections.immutableMap(it -> {
        for (SkinPaintType paintType : SkinPaintTypes.values()) {
            String name = paintType.registryName().path();
            it.put((Object)name.replaceAll("_", ""), (Object)paintType);
        }
    });
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;
    private final StringReader reader;
    private SkinPaintColor paintColor;

    public ColorParser(StringReader stringReader) {
        this.reader = stringReader;
    }

    public ColorParser parse() throws CommandSyntaxException {
        this.suggestions = this::suggestPropertyTypeAndColor;
        SkinPaintType paintType = SkinPaintTypes.NORMAL;
        if (this.reader.canRead(2)) {
            paintType = this.readPaintType();
        }
        if (!this.reader.canRead()) {
            throw ERROR_INVALID_COLOR_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)this.reader.getString());
        }
        int color = this.readPaintColor();
        this.paintColor = SkinPaintColor.of(color, paintType);
        this.suggestions = SUGGEST_NOTHING;
        return this;
    }

    public SkinPaintColor paintColor() {
        return this.paintColor;
    }

    private SkinPaintType readPaintType() throws CommandSyntaxException {
        int start = this.reader.getCursor();
        String name = this.reader.readString();
        if (!this.reader.canRead() || this.reader.peek() != ':') {
            this.reader.setCursor(start);
            return SkinPaintTypes.NORMAL;
        }
        this.reader.skip();
        SkinPaintType paintType = PAINT_TYPES.get(name.toLowerCase(Locale.ROOT));
        if (paintType == null) {
            throw ERROR_INVALID_COLOR_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)name);
        }
        this.suggestions = this::suggestPropertyColor;
        return paintType;
    }

    private int readPaintColor() throws CommandSyntaxException {
        String colorString = this.colorString();
        if (colorString.startsWith("#")) {
            this.suggestions = ColorParser.addHexSuggestions(colorString, "#ffffff");
            if (colorString.length() != 7) {
                throw ERROR_INVALID_COLOR_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)colorString);
            }
            int value = this.parseRGB(colorString);
            this.reader.setCursor(this.reader.getCursor() + colorString.length());
            return value;
        }
        if (colorString.startsWith("0x")) {
            this.suggestions = ColorParser.addHexSuggestions(colorString, "0xffffff");
            if (colorString.length() != 8) {
                throw ERROR_INVALID_COLOR_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)colorString);
            }
            int value = this.parseRGB(colorString);
            this.reader.setCursor(this.reader.getCursor() + colorString.length());
            return value;
        }
        if (colorString.contains(",")) {
            this.suggestions = ColorParser.addDecimalSuggestions(colorString, "255,255,255");
            StringReader newReader = new StringReader(this.reader);
            int r = this.parseInt(newReader);
            if (!newReader.canRead() || newReader.peek() != ',') {
                throw ERROR_INVALID_COLOR_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)colorString);
            }
            newReader.skip();
            int g = this.parseInt(newReader);
            if (!newReader.canRead() || newReader.peek() != ',') {
                throw ERROR_INVALID_COLOR_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)colorString);
            }
            newReader.skip();
            int b = this.parseInt(newReader);
            this.reader.setCursor(newReader.getCursor());
            return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
        try {
            return this.reader.readInt();
        }
        catch (Exception e) {
            throw ERROR_INVALID_COLOR_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)colorString);
        }
    }

    private int parseInt(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead()) {
            return INTEGER_ARGUMENT.parse(reader);
        }
        throw ERROR_INVALID_COLOR_FORMAT.createWithContext((ImmutableStringReader)reader, (Object)"");
    }

    private int parseRGB(String colorString) throws CommandSyntaxException {
        try {
            long value = Long.decode(colorString);
            if ((value & 0xFFFFFFFFFF000000L) == 0L) {
                value |= 0xFFFFFFFFFF000000L;
            }
            return (int)value;
        }
        catch (NumberFormatException e) {
            throw ERROR_INVALID_COLOR_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)colorString);
        }
    }

    private String colorString() {
        int start = this.reader.getCursor();
        while (this.reader.canRead() && this.isAllowedColorString(this.reader.peek())) {
            this.reader.skip();
        }
        int end = this.reader.getCursor();
        this.reader.setCursor(start);
        return this.reader.getString().substring(start, end);
    }

    private boolean isAllowedColorString(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '+' || c == ',' || c == '#';
    }

    private CompletableFuture<Suggestions> suggestPropertyTypeAndColor(SuggestionsBuilder builder) {
        String value = builder.getRemaining();
        for (String key : DEFAULT_COLORS) {
            if (!value.isEmpty() && !key.startsWith(value)) continue;
            builder.suggest(key);
        }
        for (String key : PAINT_TYPES.keySet()) {
            if (!value.isEmpty() && !key.startsWith(value)) continue;
            builder.suggest(key + ":");
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestPropertyColor(SuggestionsBuilder builder) {
        String value = builder.getRemaining();
        for (String key : DEFAULT_COLORS) {
            if (!value.isEmpty() && !key.startsWith(value)) continue;
            builder.suggest(key);
        }
        return builder.buildFuture();
    }

    private static Function<SuggestionsBuilder, CompletableFuture<Suggestions>> addDecimalSuggestions(String inputValue, String value) {
        String[] values = inputValue.split(String.valueOf(','));
        String[] targets = value.split(String.valueOf(','));
        StringBuilder targetBuilder = new StringBuilder();
        try {
            for (int i = 0; i < targets.length; ++i) {
                int intValue;
                if (i != 0) {
                    targetBuilder.append(',');
                }
                String newValue = targets[i];
                if (i < values.length) {
                    newValue = values[i];
                }
                if ((intValue = Integer.decode(newValue).intValue()) < 0 || intValue > 255) {
                    return SUGGEST_NOTHING;
                }
                targetBuilder.append(newValue);
            }
        }
        catch (Exception e) {
            return SUGGEST_NOTHING;
        }
        String targetValue = targetBuilder.toString();
        return builder -> builder.suggest(targetValue).buildFuture();
    }

    private static Function<SuggestionsBuilder, CompletableFuture<Suggestions>> addHexSuggestions(String inputValue, String value) {
        if (inputValue.length() >= value.length()) {
            return SUGGEST_NOTHING;
        }
        String newValue = inputValue + value.substring(inputValue.length());
        if (newValue.matches("(0x|#)[0-9A-Fa-f]{6}")) {
            return builder -> builder.suggest(newValue).buildFuture();
        }
        return SUGGEST_NOTHING;
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builder) {
        return this.suggestions.apply(builder.createOffset(this.reader.getCursor()));
    }
}

