/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIScrollView;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReportList
extends UIScrollView {
    private final ArrayList<GuiDetailListColumn> columns = new ArrayList();
    private final ArrayList<GuiDetailListItem> items = new ArrayList();
    protected int selectedIndex;
    protected float contentHeight = 0.0f;
    protected UIFont font = UIFont.systemFont();
    protected IEventListener listener;
    private float lastWidth;

    public ReportList(CGRect frame) {
        super(frame);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        float width = this.bounds().width();
        if (this.lastWidth != width) {
            this.lastWidth = width;
            this.contentHeight = 0.0f;
            this.items.forEach(item -> {
                item.layout(0.0f, this.contentHeight, width - 2.0f, 10.0f);
                this.contentHeight += item.contentHeight + 1.0f;
            });
            this.setContentSize(new CGSize(0.0f, this.contentHeight));
        }
    }

    public void addColumn(String name, int width) {
        this.columns.add(new GuiDetailListColumn(name, width));
    }

    public GuiDetailListColumn getColumn(int index) {
        if (index >= 0 & index < this.columns.size()) {
            return this.columns.get(index);
        }
        return null;
    }

    public void removeColumn(int index) {
        this.columns.remove(index);
    }

    public void clearColumns() {
        this.columns.clear();
    }

    public void addItem(String ... names) {
        float width = this.bounds().width();
        GuiDetailListItem item = new GuiDetailListItem(names);
        item.layout(0.0f, this.contentHeight, width - 2.0f, 10.0f);
        this.items.add(item);
        this.addSubview(item);
        this.contentHeight += item.contentHeight + 1.0f;
        this.setContentSize(new CGSize(0.0f, this.contentHeight));
    }

    public GuiDetailListItem getItem(int index) {
        if (index >= 0 & index < this.items.size()) {
            return this.items.get(index);
        }
        return null;
    }

    public void removeItem(int index) {
        this.items.get(index).removeFromSuperview();
        this.items.remove(index);
    }

    public void clearItems() {
        this.items.clear();
    }

    @Override
    protected void didScroll() {
        super.didScroll();
        if (this.listener != null) {
            this.listener.listDidScroll(this, this.contentOffset);
        }
    }

    public ReportList asReportList() {
        return this;
    }

    public float contentHeight() {
        return this.contentHeight;
    }

    public IEventListener listener() {
        return this.listener;
    }

    public void setListener(IEventListener listener) {
        this.listener = listener;
    }

    public static class GuiDetailListColumn {
        private final String name;
        private final float width;

        public GuiDetailListColumn(String name, float width) {
            this.name = name;
            this.width = width;
        }

        public String name() {
            return this.name;
        }

        public float getWidth(float listWidth) {
            return this.width;
        }
    }

    public class GuiDetailListItem
    extends UIView {
        public List<NSString> names;
        public HashMap<Integer, List<NSString>> wrappedTextLines;
        public float contentWidth;
        public float contentHeight;

        public GuiDetailListItem(String[] names) {
            super(CGRect.ZERO);
            this.wrappedTextLines = new HashMap();
            this.contentWidth = 0.0f;
            this.contentHeight = 0.0f;
            this.names = Collections.compactMap(names, NSString::new);
        }

        @Override
        public void mouseDown(UIEvent event) {
            super.mouseDown(event);
            if (ReportList.this.listener != null) {
                ReportList.this.listener.listDidSelect(ReportList.this.asReportList(), ReportList.this.items.indexOf(this));
            }
        }

        public void layout(float x, float y, float itemWidth, float itemHeight) {
            this.wrappedTextLines.clear();
            float xOffset = 0.0f;
            for (int i = 0; i < this.names.size(); ++i) {
                float columnWidth = 10.0f;
                NSString name = this.names.get(i);
                GuiDetailListColumn column = ReportList.this.getColumn(i);
                if (column != null) {
                    columnWidth = column.getWidth(itemWidth);
                    if (columnWidth == -1.0f) {
                        columnWidth = itemWidth - 2.0f - xOffset;
                    }
                    if (!name.isEmpty()) {
                        List<NSString> lines = name.split(ReportList.this.font, columnWidth);
                        itemHeight = Math.max(itemHeight, (float)(lines.size() * 10));
                        this.wrappedTextLines.put(i, lines);
                    }
                }
                xOffset += columnWidth + 1.0f;
            }
            this.contentWidth = itemWidth;
            this.contentHeight = itemHeight;
            this.setFrame(new CGRect(x + 1.0f, y + 1.0f, this.contentWidth, this.contentHeight));
        }

        @Override
        public void render(CGPoint point, CGGraphicsContext context) {
            super.render(point, context);
            float xOffset = 0.0f;
            for (int i = 0; i < this.names.size(); ++i) {
                float columnWidth = 10.0f;
                GuiDetailListColumn column = ReportList.this.getColumn(i);
                if (column == null) continue;
                columnWidth = column.getWidth(this.contentWidth);
                if (columnWidth == -1.0f) {
                    columnWidth = this.contentWidth - 2.0f - xOffset;
                }
                context.fillRect(xOffset, 0.0f, xOffset + columnWidth, this.contentHeight, -863993728);
                List<NSString> lines = this.wrappedTextLines.get(i);
                if (lines != null) {
                    int dy = 0;
                    for (NSString line : lines) {
                        context.drawText(line, 1.0f + xOffset, 1 + dy, 0xFFFFFF);
                        dy += 10;
                    }
                } else {
                    context.drawText(this.names.get(i), 1.0f + xOffset, 1.0f, 0xFFFFFF);
                }
                xOffset += columnWidth + 1.0f;
            }
        }
    }

    public static interface IEventListener {
        public void listDidSelect(ReportList var1, int var2);

        public void listDidScroll(ReportList var1, CGPoint var2);
    }
}

