/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.ClipContextImpl;
import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.platform.Window;
import java.nio.FloatBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderSystem;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.MatrixUtils;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class RenderSystem
extends AbstractRenderSystem {
    private static final AtomicInteger extendedScissorFlags = new AtomicInteger();
    private static final FloatBuffer BUFFER = MatrixUtils.createFloatBuffer(3);

    public static void safeCall(Runnable task) {
        if (RenderSystem.m_69586_()) {
            task.run();
        } else {
            RenderSystem.m_69879_(task::run);
        }
    }

    public static int getPixelColor(float x, float y) {
        Window window = EnvironmentManager.getClient().m_91268_();
        double guiScale = window.m_85449_();
        int sx = (int)((double)x * guiScale);
        int sy = (int)((double)((float)window.m_85446_() - y) * guiScale);
        BUFFER.rewind();
        GL11.glReadPixels((int)sx, (int)sy, (int)1, (int)1, (int)6407, (int)5126, (FloatBuffer)BUFFER);
        GL11.glFinish();
        int r = Math.round(BUFFER.get() * 255.0f);
        int g = Math.round(BUFFER.get() * 255.0f);
        int b = Math.round(BUFFER.get() * 255.0f);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static void addClipRect(int x, int y, int width, int height) {
        ClipContextImpl.getInstance().addClip(new ClipContextImpl.Rectangle(new CGRect(x, y, width, height)));
    }

    public static void removeClipRect() {
        ClipContextImpl.getInstance().removeClip();
    }

    public static void setShaderColor(UIColor color) {
        RenderSystem.m_157429_((float)((float)color.red() / 255.0f), (float)((float)color.green() / 255.0f), (float)((float)color.blue() / 255.0f), (float)((float)color.alpha() / 255.0f));
    }

    public static void setShaderColor(SkinPaintColor color) {
        RenderSystem.m_157429_((float)((float)color.red() / 255.0f), (float)((float)color.green() / 255.0f), (float)((float)color.blue() / 255.0f), (float)1.0f);
    }

    public static void setShaderColor(float f, float g, float h) {
        RenderSystem.m_157429_((float)f, (float)g, (float)h, (float)1.0f);
    }

    public static void setExtendedScissorFlags(int flags) {
        extendedScissorFlags.set(flags);
    }

    public static int getExtendedScissorFlags() {
        return extendedScissorFlags.get();
    }
}

