/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.data.SimpleContainer;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.apache.logging.log4j.util.Strings;

public class OutfitMakerBlockEntity
extends UpdatableContainerBlockEntity {
    private String itemName = "";
    private String itemFlavour = "";
    private final SimpleContainer container = new SimpleContainer(21);

    public OutfitMakerBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.container.deserialize(serializer);
        this.itemName = serializer.read(CodingKeys.MAKER_NAME);
        this.itemFlavour = serializer.read(CodingKeys.MAKER_FLAVOUR);
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        this.container.serialize(serializer);
        if (Strings.isNotEmpty((CharSequence)this.itemName)) {
            serializer.write(CodingKeys.MAKER_NAME, this.itemName);
        }
        if (Strings.isNotEmpty((CharSequence)this.itemFlavour)) {
            serializer.write(CodingKeys.MAKER_FLAVOUR, this.itemFlavour);
        }
    }

    public String itemName() {
        return this.itemName;
    }

    public void setItemName(String name) {
        this.itemName = name;
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public String itemFlavour() {
        return this.itemFlavour;
    }

    public void setItemFlavour(String flavour) {
        this.itemFlavour = flavour;
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    @Override
    protected SimpleContainer getContainer() {
        return this.container;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<String> MAKER_NAME = IDataSerializerKey.create("Name", IDataCodec.STRING, "");
        public static final IDataSerializerKey<String> MAKER_FLAVOUR = IDataSerializerKey.create("Flavour", IDataCodec.STRING, "");

        private CodingKeys() {
        }
    }
}

