/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document;

import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentPartMapper;
import moe.plushie.armourers_workshop.core.client.gui.notification.UserNotificationCenter;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationKeyframe;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationLoop;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchExporter;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchPack;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.blockbench.BlockBenchPackReader;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;

public class DocumentImporter {
    private boolean keepItemTransforms = false;
    private boolean isAdaptMode = false;
    private final File inputFile;
    private final SkinType targetType;
    private final DocumentPartMapper partMapper;
    private static final Set<SkinPartType> USE_ADAPT_MODE = Collections.immutableSet(builder -> {
        builder.add((Object)SkinPartTypes.BIPPED_HAT);
        builder.add((Object)SkinPartTypes.BIPPED_HEAD);
        builder.add((Object)SkinPartTypes.BIPPED_CHEST);
        builder.add((Object)SkinPartTypes.BIPPED_LEFT_ARM);
        builder.add((Object)SkinPartTypes.BIPPED_RIGHT_ARM);
        builder.add((Object)SkinPartTypes.BIPPED_SKIRT);
        builder.add((Object)SkinPartTypes.BIPPED_LEFT_THIGH);
        builder.add((Object)SkinPartTypes.BIPPED_RIGHT_THIGH);
        builder.add((Object)SkinPartTypes.BIPPED_LEFT_FOOT);
        builder.add((Object)SkinPartTypes.BIPPED_RIGHT_FOOT);
        builder.add((Object)SkinPartTypes.BIPPED_LEFT_WING);
        builder.add((Object)SkinPartTypes.BIPPED_RIGHT_WING);
        builder.add((Object)SkinPartTypes.BIPPED_LEFT_PHALANX);
        builder.add((Object)SkinPartTypes.BIPPED_RIGHT_PHALANX);
        builder.add((Object)SkinPartTypes.BIPPED_TORSO);
        builder.add((Object)SkinPartTypes.BIPPED_LEFT_HAND);
        builder.add((Object)SkinPartTypes.BIPPED_RIGHT_HAND);
        builder.add((Object)SkinPartTypes.BIPPED_LEFT_LEG);
        builder.add((Object)SkinPartTypes.BIPPED_RIGHT_LEG);
        builder.add((Object)SkinPartTypes.HORSE_HEAD);
        builder.add((Object)SkinPartTypes.HORSE_NECK);
        builder.add((Object)SkinPartTypes.HORSE_CHEST);
        builder.add((Object)SkinPartTypes.HORSE_LEFT_FRONT_THIGH);
        builder.add((Object)SkinPartTypes.HORSE_RIGHT_FRONT_THIGH);
        builder.add((Object)SkinPartTypes.HORSE_LEFT_HIND_THIGH);
        builder.add((Object)SkinPartTypes.HORSE_RIGHT_HIND_THIGH);
        builder.add((Object)SkinPartTypes.HORSE_LEFT_FRONT_LEG);
        builder.add((Object)SkinPartTypes.HORSE_RIGHT_FRONT_LEG);
        builder.add((Object)SkinPartTypes.HORSE_LEFT_HIND_LEG);
        builder.add((Object)SkinPartTypes.HORSE_RIGHT_HIND_LEG);
        builder.add((Object)SkinPartTypes.HORSE_TAIL);
        builder.add((Object)SkinPartTypes.BOAT_BODY);
        builder.add((Object)SkinPartTypes.BOAT_LEFT_PADDLE);
        builder.add((Object)SkinPartTypes.BOAT_RIGHT_PADDLE);
        builder.add((Object)SkinPartTypes.MINECART_BODY);
    });
    private static final Set<SkinType> ITEM_TYPES = Collections.immutableSet(builder -> {
        builder.add((Object)SkinTypes.ITEM_SWORD);
        builder.add((Object)SkinTypes.ITEM_SHIELD);
        builder.add((Object)SkinTypes.ITEM_BOW);
        builder.add((Object)SkinTypes.ITEM_TRIDENT);
        builder.add((Object)SkinTypes.ITEM_PICKAXE);
        builder.add((Object)SkinTypes.ITEM_AXE);
        builder.add((Object)SkinTypes.ITEM_SHOVEL);
        builder.add((Object)SkinTypes.ITEM_HOE);
        builder.add((Object)SkinTypes.ITEM_FISHING);
        builder.add((Object)SkinTypes.ITEM_BACKPACK);
        builder.add((Object)SkinTypes.ITEM);
        builder.add((Object)SkinTypes.BLOCK);
    });

    public DocumentImporter(File inputFile, SkinType targetType) {
        this.inputFile = inputFile;
        this.targetType = targetType;
        this.partMapper = DocumentPartMapper.of(targetType);
    }

    public boolean isAdaptMode() {
        return this.isAdaptMode;
    }

    public void setAdaptMode(boolean adaptMode) {
        this.isAdaptMode = adaptMode;
    }

    public boolean isKeepItemTransforms() {
        return this.keepItemTransforms;
    }

    public void setKeepItemTransforms(boolean keepItemTransforms) {
        this.keepItemTransforms = keepItemTransforms;
    }

    public void execute(Consumer<Skin> consumer) {
        this.generateSkin((skin, exception) -> {
            try {
                if (skin == null) {
                    throw exception;
                }
                consumer.accept((Skin)skin);
            }
            catch (TranslatableException e) {
                e.printStackTrace();
                NSString message = new NSString(e.getComponent());
                NSString title = NSString.localizedString("advanced-skin-builder.dialog.importer.title", new Object[0]);
                UserNotificationCenter.showToast(message, UIColor.RED, title, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                NSString message = NSString.localizedString("advanced-skin-builder.dialog.importer.unknownException", new Object[0]);
                NSString title = NSString.localizedString("advanced-skin-builder.dialog.importer.title", new Object[0]);
                UserNotificationCenter.showToast(message, UIColor.RED, title, null);
            }
        });
    }

    private void generateSkin(IResultHandler<Skin> resultHandler) {
        EnvironmentExecutor.runOnBackground(() -> () -> {
            try {
                if (!this.inputFile.exists()) {
                    throw new TranslatableException("inventory.armourers_workshop.skin-library.error.illegalModelFile", new Object[0]);
                }
                Skin skin = this.readSkinFromFile(this.inputFile);
                if (skin == null || skin.parts().isEmpty()) {
                    throw new TranslatableException("inventory.armourers_workshop.skin-library.error.illegalModelFormat", new Object[0]);
                }
                EnvironmentManager.getClient().execute(() -> resultHandler.accept(this.apply(skin)));
            }
            catch (Exception e) {
                EnvironmentManager.getClient().execute(() -> resultHandler.abort(e));
            }
        });
    }

    private Skin readSkinFromFile(File file) throws IOException {
        return this.readSkinFromReader(new BlockBenchPackReader(file));
    }

    private Skin readSkinFromReader(BlockBenchPackReader reader) throws IOException {
        List<String> authors;
        String description;
        BlockBenchPack pack = reader.readPack();
        BlockBenchExporter exporter = new BlockBenchExporter(pack);
        SkinSettings settings = exporter.settings();
        SkinProperties properties = exporter.properties();
        String name = pack.name();
        if (name != null && !name.isEmpty()) {
            properties.put(SkinProperty.ALL_CUSTOM_NAME, name);
        }
        if ((description = pack.description()) != null && !description.isEmpty()) {
            properties.put(SkinProperty.ALL_FLAVOUR_TEXT, description);
        }
        if ((authors = pack.authors()) != null && !authors.isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            authors.forEach(joiner::add);
            properties.put(SkinProperty.ALL_AUTHOR_NAME, joiner.toString());
        }
        properties.put(SkinProperty.ALL_AUTHOR_UUID, "generated by block bench importer");
        settings.setEditable(true);
        exporter.setOffset(this.getOffset(pack));
        exporter.setDisplayOffset(this.getDisplayOffset(pack));
        exporter.setCulling(this.isCulling(pack));
        return exporter.export();
    }

    private Skin apply(Skin skin) {
        Object builder;
        SkinSettings settings = skin.settings().copy();
        SkinProperties properties = skin.properties().copy();
        if (!this.isKeepItemTransforms()) {
            settings.setItemTransforms(null);
        }
        List<SkinPart> resolvedParts = this.resolveMappedParts(skin.parts());
        List<SkinAnimation> resolvedAnimations = this.resolveMappedAnimations(skin.animations());
        ArrayList<SkinPart> rootParts = new ArrayList<SkinPart>(resolvedParts);
        if (this.partMapper.root() != null) {
            DocumentPartMapper.Entry rootEntry = this.partMapper.root();
            SkinPart.Builder builder2 = new SkinPart.Builder(rootEntry.type());
            builder2.children(resolvedParts);
            rootParts.clear();
            rootParts.add(builder2.build());
        } else if (this.isAdaptMode) {
            builder = new SkinPart.Builder(SkinPartTypes.ADVANCED_STATIC);
            ((SkinPart.Builder)builder).children(resolvedParts);
            rootParts.clear();
            rootParts.add(((SkinPart.Builder)builder).build());
        } else if (!this.partMapper.isEmpty()) {
            resolvedParts.forEach(it -> this.extractToRootPart((SkinPart)it, new Stack<SkinPart>(), (List<SkinPart>)rootParts));
        }
        builder = new Skin.Builder(SkinTypes.ADVANCED);
        ((Skin.Builder)builder).parts(rootParts);
        ((Skin.Builder)builder).settings(settings);
        ((Skin.Builder)builder).properties(properties);
        ((Skin.Builder)builder).animations(resolvedAnimations);
        ((Skin.Builder)builder).version(25);
        return ((Skin.Builder)builder).build();
    }

    public List<SkinPart> resolveMappedParts(List<SkinPart> parts) {
        ArrayList<SkinPart> results = new ArrayList<SkinPart>();
        for (SkinPart part : parts) {
            DocumentPartMapper.Node node = this.partMapper.resolve(part.name(), part.type());
            SkinPart.Builder builder = new SkinPart.Builder(node.type());
            builder.copyFrom(part);
            if (this.isAdaptMode && USE_ADAPT_MODE.contains(node.type())) {
                SkinProperties newProperties = part.properties().copy();
                newProperties.put(SkinProperty.USE_ADAPT_MODE, true);
                builder.properties(newProperties);
            }
            builder.name(node.name());
            builder.children(this.resolveMappedParts((List<SkinPart>)part.children()));
            results.add(builder.build());
        }
        return results;
    }

    private List<SkinAnimation> resolveMappedAnimations(List<SkinAnimation> animations) {
        ArrayList<SkinAnimation> results = new ArrayList<SkinAnimation>();
        for (SkinAnimation animation : animations) {
            LinkedHashMap<String, List<SkinAnimationKeyframe>> keyframes = new LinkedHashMap<String, List<SkinAnimationKeyframe>>();
            animation.keyframes().forEach((key, value) -> {
                DocumentPartMapper.Node node = this.partMapper.resolve((String)key, SkinPartTypes.ADVANCED);
                keyframes.put(node.name(), (List<SkinAnimationKeyframe>)value);
            });
            String name = animation.name();
            float duration = animation.duration();
            SkinAnimationLoop loop = animation.loop();
            results.add(new SkinAnimation(name, duration, loop, keyframes));
        }
        return results;
    }

    private void extractToRootPart(SkinPart part, Stack<SkinPart> parent, List<SkinPart> rootParts) {
        ArrayList children = new ArrayList(part.children());
        for (SkinPart child : children) {
            parent.push(part);
            this.extractToRootPart(child, parent, rootParts);
            parent.pop();
        }
        DocumentPartMapper.Entry entry = this.partMapper.get(part.name());
        if (entry != null && entry.isRootPart()) {
            if (parent.isEmpty()) {
                rootParts.remove(part);
            } else {
                SkinPart parentPart = parent.peek();
                parentPart.removePart(part);
            }
            SkinPart.Builder builder = new SkinPart.Builder(entry.type());
            builder.copyFrom(part);
            builder.transform(this.convertToLocal(part, entry, parent));
            rootParts.add(builder.build());
        }
    }

    private OpenTransform3f convertToLocal(SkinPart part, DocumentPartMapper.Entry entry, Stack<SkinPart> parent) {
        OpenVector3f translate = entry.offset();
        OpenVector3f rotation = OpenVector3f.ZERO;
        return OpenTransform3f.create(translate, rotation, OpenVector3f.ONE);
    }

    private boolean isCulling(BlockBenchPack pack) {
        return pack.format().equals("java_block");
    }

    private OpenVector3f getOffset(BlockBenchPack pack) {
        if (ITEM_TYPES.contains(this.targetType)) {
            if (pack.format().equals("java_block")) {
                return new OpenVector3f(8.0f, 8.0f, 8.0f);
            }
            return new OpenVector3f(0.0f, 8.0f, 0.0f);
        }
        if (this.targetType == SkinTypes.OUTFIT || this.targetType == SkinTypes.ARMOR_HEAD || this.targetType == SkinTypes.ARMOR_CHEST || this.targetType == SkinTypes.ARMOR_LEGS || this.targetType == SkinTypes.ARMOR_FEET || this.targetType == SkinTypes.ARMOR_WINGS) {
            return new OpenVector3f(0.0f, 24.0f, 0.0f);
        }
        if (this.targetType == SkinTypes.HORSE) {
            return new OpenVector3f(0.0f, 24.0f, 0.0f);
        }
        return OpenVector3f.ZERO;
    }

    private OpenVector3f getDisplayOffset(BlockBenchPack pack) {
        if (pack.format().equals("java_block")) {
            return OpenVector3f.ZERO;
        }
        return new OpenVector3f(0.0f, 8.0f, 0.0f);
    }

    private OpenVector3f getParentOrigin(Stack<SkinPart> parent) {
        OpenVector3f origin = OpenVector3f.ZERO;
        for (SkinPart part : parent) {
            ITransform iTransform = part.transform();
            if (!(iTransform instanceof OpenTransform3f)) continue;
            OpenTransform3f transform = (OpenTransform3f)iTransform;
            origin = origin.adding(transform.translate());
        }
        return origin;
    }
}

