/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.undo;

import java.util.Stack;
import moe.plushie.armourers_workshop.api.action.IUserAction;
import moe.plushie.armourers_workshop.builder.data.undo.action.ActionRuntimeException;
import moe.plushie.armourers_workshop.init.ModConfig;
import net.minecraft.class_2561;

public class UndoStack {
    private final Stack<IUserAction> undoStack = new Stack();
    private final Stack<IUserAction> redoStack = new Stack();

    public IUserAction undo() throws RuntimeException {
        if (this.undoStack.isEmpty()) {
            throw new ActionRuntimeException((class_2561)class_2561.method_43471((String)"chat.armourers_workshop.undo.outOfUndos"));
        }
        IUserAction changes = this.undoStack.peek();
        this.redoStack.push(changes.apply());
        this.undoStack.pop();
        return changes;
    }

    public IUserAction redo() throws RuntimeException {
        if (this.redoStack.isEmpty()) {
            throw new ActionRuntimeException((class_2561)class_2561.method_43471((String)"chat.armourers_workshop.undo.outOfRedos"));
        }
        IUserAction changes = this.redoStack.peek();
        this.undoStack.push(changes.apply());
        this.redoStack.pop();
        return changes;
    }

    public void push(IUserAction action) {
        this.undoStack.push(action);
        this.redoStack.clear();
        while (!this.undoStack.isEmpty() && this.undoStack.size() > ModConfig.Common.maxUndos) {
            this.undoStack.removeElementAt(0);
        }
    }

    public void clear() {
        this.undoStack.clear();
        this.redoStack.clear();
    }
}

