/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.builder.other.CubeChanges;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class CubeWrapper
implements IBlockPaintable {
    private final Consumer<CubeChanges> consumer;
    private final class_1937 level;
    private class_2338 pos;
    private Supplier<class_2680> state;
    private Supplier<class_2586> blockEntity;
    private Supplier<IBlockPaintable> target;
    private CubeChanges changes;

    public CubeWrapper(class_1937 level, Consumer<CubeChanges> consumer) {
        this.consumer = consumer;
        this.level = level;
    }

    public boolean is(Class<?> clazz) {
        if (class_2248.class.isAssignableFrom(clazz)) {
            return clazz.isInstance(this.block());
        }
        return clazz.isInstance(this.blockEntity());
    }

    public boolean is(class_2248 block) {
        return this.blockState().method_27852(block);
    }

    public class_2248 block() {
        return this.blockState().method_26204();
    }

    public class_2680 blockState() {
        if (this.state != null) {
            return this.state.get();
        }
        if (this.pos != null) {
            class_2680 state = this.level.method_8320(this.pos);
            this.state = () -> state;
            return state;
        }
        return class_2246.field_10124.method_9564();
    }

    public void setBlockState(class_2680 state) {
        this.lastChanges().setBlockState(state);
    }

    public void setBlockStateAndTag(class_2680 state, class_2487 nbt) {
        this.lastChanges().setBlockState(state);
        this.lastChanges().setCompoundTag(nbt);
    }

    public void setBlockStateAndColors(class_2680 state, Map<OpenDirection, SkinPaintColor> colors) {
        this.lastChanges().setBlockState(state);
        this.lastChanges().setColors(colors);
    }

    @Nullable
    public class_2586 blockEntity() {
        if (this.blockEntity != null) {
            return this.blockEntity.get();
        }
        if (this.pos != null) {
            class_2586 blockEntity = this.level.method_8321(this.pos);
            this.blockEntity = () -> blockEntity;
            return blockEntity;
        }
        return null;
    }

    @Nullable
    public class_2487 blockTag() {
        class_2586 blockEntity = this.blockEntity();
        if (blockEntity != null) {
            return StorageAPI.saveFullData(blockEntity, this.level.method_30349());
        }
        return null;
    }

    @Override
    public SkinPaintColor getColor(OpenDirection direction) {
        IBlockPaintable target = this.target();
        if (target != null) {
            return target.getColor(direction);
        }
        return null;
    }

    @Override
    public void setColor(OpenDirection direction, SkinPaintColor color) {
        this.lastChanges().setColor(direction, color);
    }

    @Override
    public void setColors(Map<OpenDirection, SkinPaintColor> colors) {
        this.lastChanges().setColors(colors);
    }

    @Override
    public boolean shouldChangeColor(OpenDirection direction) {
        IBlockPaintable target = this.target();
        if (target != null) {
            return target.shouldChangeColor(direction);
        }
        return false;
    }

    public class_2338 blockPos() {
        return this.pos;
    }

    public void setBlockPos(class_2338 pos) {
        if (this.pos != pos) {
            this.submit();
        }
        this.pos = pos;
    }

    private IBlockPaintable target() {
        if (this.target != null) {
            return this.target.get();
        }
        IBlockPaintable target = Objects.safeCast(this.blockEntity(), IBlockPaintable.class);
        if (target != null) {
            this.target = () -> target;
            return target;
        }
        return null;
    }

    private CubeChanges lastChanges() {
        if (this.changes == null) {
            this.changes = new CubeChanges(this.level, this.pos);
        }
        return this.changes;
    }

    private void submit() {
        if (this.changes != null) {
            this.consumer.accept(this.changes);
            this.changes = null;
        }
        this.pos = null;
        this.state = null;
        this.blockEntity = null;
        this.target = null;
    }
}

