/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import java.util.Optional;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModPermissions;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public abstract class AbstractMenuType<C extends class_1703>
implements IMenuType<C> {
    private IResourceLocation registryName;

    @Override
    public <T> class_1269 openMenu(class_1657 player, T value) {
        if (player == null || value == null) {
            return class_1269.field_5814;
        }
        if (!(player instanceof class_3222)) {
            return class_1269.field_21466;
        }
        class_3222 serverPlayer = (class_3222)player;
        IGlobalPos globalPos = this.getGlobalPos(value);
        if (globalPos != null) {
            return this.openMenu(serverPlayer, globalPos, null).orElse(class_1269.field_5814);
        }
        return this.openMenu(serverPlayer, this.title(), value);
    }

    protected Optional<class_1269> openMenu(class_3222 player, IGlobalPos globalPos, Object extraData) {
        return globalPos.evaluate((level, blockPos) -> {
            if (!ModPermissions.OPEN.accept(this, (class_1937)level, (class_2338)blockPos, (class_1657)player)) {
                return class_1269.field_5814;
            }
            return this.openMenu(player, this.title(), globalPos);
        });
    }

    protected abstract <T> class_1269 openMenu(class_3222 var1, class_2561 var2, T var3);

    protected <T> IGlobalPos getGlobalPos(T value) {
        if (value instanceof IGlobalPos) {
            IGlobalPos globalPos = (IGlobalPos)value;
            return globalPos;
        }
        if (value instanceof class_2586) {
            class_2586 blockEntity = (class_2586)value;
            return IGlobalPos.create(blockEntity.method_10997(), blockEntity.method_11016());
        }
        return null;
    }

    @Override
    public class_2561 title() {
        return TranslateUtils.title("inventory.armourers_workshop." + this.registryName().path(), new Object[0]);
    }

    @Override
    public IResourceLocation registryName() {
        return this.registryName;
    }

    public void setRegistryName(IResourceLocation registryName) {
        this.registryName = registryName;
    }
}

