/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRegistryManager {
    private static final Map<class_1792, String> ITEM_NAMES = new ConcurrentHashMap<class_1792, String>();
    private static final Map<class_2248, String> BLOCK_NAMES = new ConcurrentHashMap<class_2248, String>();
    private static final Map<String, Optional<Predicate<class_1799>>> NAMED_ITEM_TAGS = new ConcurrentHashMap<String, Optional<Predicate<class_1799>>>();
    private static final Map<String, Optional<Predicate<class_2680>>> NAMED_BLOCK_TAGS = new ConcurrentHashMap<String, Optional<Predicate<class_2680>>>();
    private static final Map<String, Optional<Predicate<Biome>>> NAMED_BIOME_TAGS = new ConcurrentHashMap<String, Optional<Predicate<Biome>>>();
    private static final Map<String, Optional<Function<class_1309, Double>>> NAMED_ATTRIBUTES = new ConcurrentHashMap<String, Optional<Function<class_1309, Double>>>();
    private static final Map<String, Optional<Function<class_1309, class_1293>>> NAMED_EFFECTS = new ConcurrentHashMap<String, Optional<Function<class_1309, class_1293>>>();
    private static final Map<String, Optional<Function<class_1799, Integer>>> NAMED_ENCHANTMENTS = new ConcurrentHashMap<String, Optional<Function<class_1799, Integer>>>();

    public static String getItemKey(class_1792 item) {
        return ITEM_NAMES.computeIfAbsent(item, it -> EnvironmentManager.getRegistryManager().getItemKey0((class_1792)it).toString());
    }

    public static String getBlockKey(class_2248 block) {
        return BLOCK_NAMES.computeIfAbsent(block, it -> EnvironmentManager.getRegistryManager().getBlockKey0((class_2248)it).toString());
    }

    public static boolean hasItemTag(class_1799 itemStack, String tagName) {
        Optional tag = NAMED_ITEM_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getItemTag0));
        return tag.map(it -> it.test(itemStack)).orElse(false);
    }

    public static boolean hasBlockTag(class_2680 blockState, String tagName) {
        Optional tag = NAMED_BLOCK_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getBlockTag0));
        return tag.map(it -> it.test(blockState)).orElse(false);
    }

    public static boolean hasBiomeTag(Biome biome, String tagName) {
        Optional tag = NAMED_BIOME_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getBiomeTag0));
        return tag.map(it -> it.test(biome)).orElse(false);
    }

    public static Biome getBiome(final class_1937 level, final class_2338 blockPos) {
        return new Biome(){

            @Override
            public class_1937 getLevel() {
                return level;
            }

            @Override
            public class_2338 getBlockPos() {
                return blockPos;
            }
        };
    }

    @Nullable
    public static class_1293 getEffect(class_1309 entity, String effectName) {
        Optional value = NAMED_EFFECTS.computeIfAbsent(effectName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getEffect0));
        return value.map(it -> (class_1293)it.apply(entity)).orElse(null);
    }

    public static double getAttribute(class_1309 entity, String attributeName) {
        Optional value = NAMED_ATTRIBUTES.computeIfAbsent(attributeName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getAttribute0));
        return value.map(it -> (Double)it.apply(entity)).orElse(0.0);
    }

    public static Object getEnchantment(class_1799 itemStack, String enchantmentName) {
        Optional value = NAMED_ENCHANTMENTS.computeIfAbsent(enchantmentName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getEnchantment0));
        return value.map(it -> (Integer)it.apply(itemStack)).orElse(null);
    }

    private static <T> Optional<T> parse(String name, BiFunction<AbstractRegistryManager, class_2960, T> factory) {
        class_2960 key = class_2960.method_12829((String)name);
        if (key != null) {
            return Optional.ofNullable(factory.apply(EnvironmentManager.getRegistryManager(), key));
        }
        return Optional.empty();
    }

    protected abstract class_2960 getItemKey0(class_1792 var1);

    protected abstract class_2960 getBlockKey0(class_2248 var1);

    protected abstract Predicate<class_1799> getItemTag0(class_2960 var1);

    protected abstract Predicate<class_2680> getBlockTag0(class_2960 var1);

    protected abstract Predicate<Biome> getBiomeTag0(class_2960 var1);

    protected abstract Function<class_1799, Integer> getEnchantment0(class_2960 var1);

    protected abstract Function<class_1309, class_1293> getEffect0(class_2960 var1);

    protected abstract Function<class_1309, Double> getAttribute0(class_2960 var1);

    public static interface Biome {
        public class_1937 getLevel();

        public class_2338 getBlockPos();
    }
}

