/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointFilter;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;

public class BakedArmature {
    private static final HashMap<Armature, BakedArmature> DEFAULT_IMMUTABLE_ARMATURES = new HashMap();
    private static final HashMap<Armature, BakedArmature> DEFAULT_MUTABLE_ARMATURES = new HashMap();
    private final Armature armature;
    private final IJointTransform[] defaultTransforms;
    private IJointFilter filter;
    private IJointTransform[] finalTransforms;

    public BakedArmature(Armature armature) {
        this.armature = armature;
        this.defaultTransforms = new IJointTransform[armature.size()];
        this.finalTransforms = this.defaultTransforms;
        for (int i = 0; i < this.defaultTransforms.length; ++i) {
            this.defaultTransforms[i] = armature.globalTransformById(i);
        }
    }

    public static BakedArmature defaultBy(Armature armature) {
        return DEFAULT_IMMUTABLE_ARMATURES.computeIfAbsent(armature, BakedArmature::new);
    }

    public static BakedArmature defaultBy(SkinType skinType) {
        return BakedArmature.defaultBy(Armatures.byType(skinType));
    }

    public static BakedArmature mutableBy(Armature armature) {
        return DEFAULT_MUTABLE_ARMATURES.computeIfAbsent(armature, BakedArmature::new);
    }

    public static BakedArmature mutableBy(SkinType skinType) {
        return BakedArmature.mutableBy(Armatures.byType(skinType));
    }

    public void setFilter(IJointFilter filter) {
        this.filter = filter;
    }

    public IJointFilter filter() {
        return this.filter;
    }

    public IJoint jointByType(SkinPartType partType) {
        IJoint joint = this.armature.jointByType(partType);
        if (joint != null && this.filter != null && !this.filter.test(joint)) {
            return null;
        }
        return joint;
    }

    public IJoint jointByPart(BakedSkinPart bakedPart) {
        SkinPartType partType = bakedPart.type();
        if (partType == SkinPartTypes.BIPPED_LEFT_WING && bakedPart.properties().get(SkinProperty.WINGS_MATCHING_POSE).booleanValue()) {
            return this.jointByType(SkinPartTypes.BIPPED_LEFT_PHALANX);
        }
        if (partType == SkinPartTypes.BIPPED_RIGHT_WING && bakedPart.properties().get(SkinProperty.WINGS_MATCHING_POSE).booleanValue()) {
            return this.jointByType(SkinPartTypes.BIPPED_RIGHT_PHALANX);
        }
        return this.jointByType(partType);
    }

    public IJointTransform transformByJoint(IJoint joint) {
        if (joint != null) {
            return this.finalTransforms[joint.id()];
        }
        return null;
    }

    public IJointTransform transformByType(SkinPartType partType) {
        return this.transformByJoint(this.jointByType(partType));
    }

    public IJointTransform transformByPart(BakedSkinPart bakedPart) {
        IJointTransform transform = this.transformByJoint(this.jointByPart(bakedPart));
        Function<IJointTransform, IJointTransform> transformModifier = bakedPart.jointTransformModifier();
        if (transformModifier != null) {
            return transformModifier.apply(transform);
        }
        return transform;
    }

    public void seTransforms(IJointTransform[] transforms) {
        this.finalTransforms = transforms != null ? transforms : this.defaultTransforms;
    }

    public IJointTransform[] transforms() {
        return this.finalTransforms;
    }

    public Armature armature() {
        return this.armature;
    }
}

