/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.skinningtable;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIControl;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;

public class SkinningTableSettingWindow
extends ConfirmDialog {
    private final SkinDescriptor.Options options;
    private int contentHeight = 24;

    public SkinningTableSettingWindow(SkinDescriptor.Options options) {
        this.options = options.copy();
        this.setup();
        this.contentHeight += 6;
    }

    private void setup() {
        this.messageLabel.removeFromSuperview();
        this.addOptionView(Option.ITEM_RENDERER_SHOW_SKIN);
        this.addOptionView(Option.TOOLTIP_SHOW_NAME);
        this.addOptionView(Option.TOOLTIP_SHOW_AUTHOR);
        this.addOptionView(Option.TOOLTIP_SHOW_SKIN_TYPE);
        this.addOptionView(Option.TOOLTIP_SHOW_FLAVOUR);
        this.addOptionView(Option.TOOLTIP_SHOW_HAS_SKIN);
        this.addOptionView(Option.TOOLTIP_SHOW_OPEN_WARDROBE);
        this.addOptionView(Option.TOOLTIP_SHOW_SKIN_PREVIEW);
    }

    private UICheckBox addOptionView(Option<Boolean> option) {
        UICheckBox checkBox = new UICheckBox(new CGRect(8.0f, this.contentHeight, this.bounds().width() - 16.0f, 9.0f));
        checkBox.setTitle(NSString.localizedString("skinning-table.setting." + option.key, new Object[0]));
        checkBox.setSelected(option.get(this.options));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, sender) -> option.set(this.options, checkBox.isSelected()));
        checkBox.setAutoresizingMask(34);
        this.addSubview(checkBox);
        this.contentHeight += 13;
        return checkBox;
    }

    @Override
    public void sizeToFit() {
        this.setBounds(new CGRect(0.0f, 0.0f, this.bounds().width(), this.contentHeight + 30));
    }

    public SkinDescriptor.Options options() {
        return this.options.copy();
    }

    public static abstract class Option<T> {
        public static final Option<Boolean> TOOLTIP_SHOW_NAME = Option.flags("tooltip.showName", SkinDescriptor.TooltipFlags.NAME);
        public static final Option<Boolean> TOOLTIP_SHOW_AUTHOR = Option.flags("tooltip.showAuthor", SkinDescriptor.TooltipFlags.AUTHOR);
        public static final Option<Boolean> TOOLTIP_SHOW_FLAVOUR = Option.flags("tooltip.showFlavour", SkinDescriptor.TooltipFlags.AUTHOR);
        public static final Option<Boolean> TOOLTIP_SHOW_HAS_SKIN = Option.flags("tooltip.showHasSkin", SkinDescriptor.TooltipFlags.HAS_SKIN);
        public static final Option<Boolean> TOOLTIP_SHOW_OPEN_WARDROBE = Option.flags("tooltip.showOpenWardrobe", SkinDescriptor.TooltipFlags.OPEN_WARDROBE);
        public static final Option<Boolean> TOOLTIP_SHOW_SKIN_TYPE = Option.flags("tooltip.showSkinType", SkinDescriptor.TooltipFlags.TYPE);
        public static final Option<Boolean> TOOLTIP_SHOW_SKIN_PREVIEW = Option.flags("tooltip.showSkinPreview", SkinDescriptor.TooltipFlags.PREVIEW);
        public static final Option<Boolean> ITEM_RENDERER_SHOW_SKIN = Option.itemRenderer("itemRenderer.showSkin");
        private final String key;

        public Option(String key) {
            this.key = key;
        }

        public static Option<Boolean> flags(String key, final SkinDescriptor.TooltipFlags flags) {
            return new Option<Boolean>(key){

                @Override
                public Boolean get(SkinDescriptor.Options options) {
                    return options.getTooltip(flags);
                }

                @Override
                public void set(SkinDescriptor.Options options, Boolean value) {
                    options.setTooltip(flags, value);
                }
            };
        }

        public static Option<Boolean> itemRenderer(String key) {
            return new Option<Boolean>(key){

                @Override
                public Boolean get(SkinDescriptor.Options options) {
                    return options.embeddedItemRenderer() == 2;
                }

                @Override
                public void set(SkinDescriptor.Options options, Boolean value) {
                    if (value.booleanValue()) {
                        options.setEnableEmbeddedItemRenderer(2);
                    } else {
                        options.setEnableEmbeddedItemRenderer(0);
                    }
                }
            };
        }

        public abstract T get(SkinDescriptor.Options var1);

        public abstract void set(SkinDescriptor.Options var1, T var2);
    }
}

