/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.wardrobe;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextRange;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.gui.notification.UserNotificationCenter;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeBaseSetting;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import org.apache.logging.log4j.util.Strings;

@Environment(value=EnvType.CLIENT)
public class SkinWardrobeTextureSetting
extends SkinWardrobeBaseSetting
implements UITextFieldDelegate {
    private final SkinWardrobe wardrobe;
    private final HashMap<EntityTextureDescriptor.Source, String> defaultValues = new HashMap();
    private final UITextField textField = new UITextField(new CGRect(83.0f, 70.0f, 165.0f, 18.0f));
    private UIButton confirmView;
    private UIComboBox sourceComboView;
    private UIComboBox modelComboView;
    private EntityTextureDescriptor lastDescriptor = EntityTextureDescriptor.EMPTY;
    private EntityTextureDescriptor.Model lastTextureModel = EntityTextureDescriptor.Model.STEVE;
    private EntityTextureDescriptor.Source lastTextureSource = EntityTextureDescriptor.Source.USER;

    public SkinWardrobeTextureSetting(SkinWardrobe wardrobe) {
        super("wardrobe.man_texture");
        this.wardrobe = wardrobe;
        this.prepareDefaultValue();
        this.setup();
    }

    private void setup() {
        this.setupTextField();
        this.confirmView = this.addCommonButton(83.0f, 90.0f, 100.0f, 20.0f, "set", this::submit);
        this.sourceComboView = this.addComboBox(83.0f, 27.0f, 80.0f, 14.0f, "textureSource", this.lastTextureSource, this::applyTextureSource);
        this.modelComboView = this.addComboBox(168.0f, 27.0f, 80.0f, 14.0f, "textureModel", this.lastTextureModel, this::applyTextureModel);
    }

    public void setupTextField() {
        this.textField.setDelegate(this);
        this.textField.setMaxLength(1024);
        this.textField.setText(Objects.compactMap(this.defaultValues.get((Object)this.lastTextureSource), ""));
        this.addSubview(this.textField);
    }

    private void prepareDefaultValue() {
        class_1297 class_12972 = this.wardrobe.entity();
        if (!(class_12972 instanceof MannequinEntity)) {
            return;
        }
        MannequinEntity entity = (MannequinEntity)class_12972;
        this.lastDescriptor = entity.getTextureDescriptor();
        this.lastTextureModel = entity.getTextureModel();
        this.lastTextureSource = this.lastDescriptor.source().orElse(EntityTextureDescriptor.Source.USER);
        this.defaultValues.clear();
        this.defaultValues.put(this.lastTextureSource, this.lastDescriptor.value().orElse(""));
    }

    private void applyTextureSource(EntityTextureDescriptor.Source newValue) {
        if (this.lastTextureSource == newValue) {
            return;
        }
        this.defaultValues.put(this.lastTextureSource, this.textField.text());
        this.textField.setText(Objects.compactMap(this.defaultValues.get((Object)newValue), ""));
        this.textField.resignFirstResponder();
        this.textField.setSelectedTextRange(new NSTextRange(this.textField.beginOfDocument()));
        this.sourceComboView.setSelectedIndex(newValue.ordinal());
        this.lastTextureSource = newValue;
    }

    private void applyTextureModel(EntityTextureDescriptor.Model newValue) {
        if (this.lastTextureModel == newValue) {
            return;
        }
        this.modelComboView.setSelectedIndex(newValue.ordinal());
        NetworkManager.sendToServer(UpdateWardrobePacket.Field.MANNEQUIN_TEXTURE_MODEL.buildPacket(this.wardrobe, newValue));
        this.lastTextureModel = newValue;
    }

    private void submit(Object button) {
        this.textField.resignFirstResponder();
        this.confirmView.setEnabled(false);
        EntityTextureLoader.getInstance().loadTexture(this.getTextureDescriptor(), (texture, exception) -> {
            this.confirmView.setEnabled(true);
            if (texture == null) {
                UserNotificationCenter.showToast(exception, NSString.localizedString("common.text.error", new Object[0]), null);
                return;
            }
            EntityTextureDescriptor newValue = texture.descriptor();
            if (this.lastDescriptor.equals(newValue)) {
                return;
            }
            this.lastDescriptor = newValue;
            this.lastTextureSource = null;
            NetworkManager.sendToServer(UpdateWardrobePacket.Field.MANNEQUIN_TEXTURE.buildPacket(this.wardrobe, newValue));
            EntityTextureDescriptor.Source newSource = newValue.source().orElse(EntityTextureDescriptor.Source.USER);
            this.defaultValues.put(newSource, newValue.value().orElse(""));
            this.applyTextureSource(newSource);
        });
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.submit(textField.text());
        return true;
    }

    private <T extends Enum<T>> UIComboBox addComboBox(float x, float y, float width, float height, String key, T defaultValue, Consumer<T> applier) {
        ArrayList<Enum> values = Collections.newList((Enum[])defaultValue.getClass().getEnumConstants());
        UIComboBox comboView = new UIComboBox(new CGRect(x, y, width, height));
        comboView.setSelectedIndex(values.indexOf(defaultValue));
        comboView.reloadData(Collections.compactMap(values, value -> {
            String name = value.name().toLowerCase();
            return new UIComboItem(this.getDisplayText(key + "." + name, new Object[0]));
        }));
        comboView.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, e) -> {
            int newValue = ((UIComboBox)e).selectedIndex();
            applier.accept((Enum)Objects.unsafeCast((Enum)values.get(newValue)));
        });
        this.addSubview(comboView);
        return comboView;
    }

    private UIButton addCommonButton(float x, float y, float width, float height, String key, Consumer<UIControl> handler) {
        UIButton button = new UIButton(new CGRect(x, y, width, height));
        button.setTitle(this.getDisplayText(key, new Object[0]), 7);
        button.setTitleColor(UIColor.WHITE, 7);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, (self, e) -> handler.accept((UIControl)e));
        this.addSubview(button);
        return button;
    }

    private EntityTextureDescriptor getTextureDescriptor() {
        String value = this.textField.text();
        if (Strings.isNotEmpty((CharSequence)value)) {
            EntityTextureDescriptor.Source userType = EntityTextureDescriptor.Source.values()[this.sourceComboView.selectedIndex()];
            if (userType == EntityTextureDescriptor.Source.URL) {
                return EntityTextureDescriptor.fromURL(value);
            }
            if (userType == EntityTextureDescriptor.Source.USER) {
                return EntityTextureDescriptor.fromName(value);
            }
        }
        return EntityTextureDescriptor.EMPTY;
    }
}

