/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.plugin;

import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.data.DataContainerKey;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3481;

public class MinecartModelArmaturePlugin
extends ArmaturePlugin {
    private static final DataContainerKey<Boolean> IS_FLAPPED = DataContainerKey.of("isFlapped", Boolean.class, () -> false);

    public MinecartModelArmaturePlugin(ArmatureTransformerContext context) {
    }

    @Override
    public void activate(class_1297 entity, ArmaturePlugin.Context context) {
        class_1688 minecart = (class_1688)entity;
        IPoseStack poseStack = context.poseStack();
        if (this.isFlapped(minecart, context.partialTicks(), context.renderData())) {
            poseStack.rotate(OpenVector3f.YP.rotationDegrees(180.0f));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -0.125f, 0.0f);
        poseStack.rotate(OpenVector3f.YP.rotationDegrees(180.0f));
    }

    private boolean isFlapped(class_1688 entity, float partialTicks, EntityRenderData renderData) {
        class_2680 blockState;
        int k;
        int j;
        int i;
        class_243 delta = entity.method_18798();
        double dx = delta.method_10216();
        double dz = delta.method_10215();
        if (dx == 0.0 && dz == 0.0) {
            return renderData.getAssociatedObject(IS_FLAPPED);
        }
        class_1937 level = entity.method_37908();
        if (level.method_8320(new class_2338(i = OpenMath.floori(OpenMath.lerp((double)partialTicks, entity.field_6038, entity.method_23317())), (j = OpenMath.floori(OpenMath.lerp((double)partialTicks, entity.field_5971, entity.method_23318()))) - 1, k = OpenMath.floori(OpenMath.lerp((double)partialTicks, entity.field_5989, entity.method_23321())))).method_26164(class_3481.field_15463)) {
            --j;
        }
        if (!class_2241.method_9476((class_2680)(blockState = level.method_8320(new class_2338(i, j, k))))) {
            return renderData.getAssociatedObject(IS_FLAPPED);
        }
        class_2768 shape = (class_2768)blockState.method_11654(((class_2241)blockState.method_26204()).method_9474());
        boolean result = this.isFlapped(shape, dx, dz);
        renderData.setAssociatedObject(IS_FLAPPED, result);
        return result;
    }

    private boolean isFlapped(class_2768 shape, double x, double z) {
        double eps = 0.001;
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case class_2768.field_12672, class_2768.field_12663 -> {
                if (z < -eps) {
                    yield true;
                }
                yield false;
            }
            case class_2768.field_12664, class_2768.field_12671 -> {
                if (z > eps) {
                    yield true;
                }
                yield false;
            }
            case class_2768.field_12665 -> {
                if (z < -eps) {
                    yield true;
                }
                yield false;
            }
            case class_2768.field_12674 -> {
                if (x < -eps) {
                    yield true;
                }
                yield false;
            }
            case class_2768.field_12667, class_2768.field_12666 -> {
                if (x < -eps) {
                    yield true;
                }
                yield false;
            }
            case class_2768.field_12670, class_2768.field_12668 -> z < -eps;
        };
    }
}

