/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import java.util.IdentityHashMap;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.compatibility.client.AbstractSimpleTexture;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.texture.TextureManager.UnregisteringAPI;
import moe.plushie.armourers_workshop.core.client.texture.SmartTexture;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1060;

@Environment(value=EnvType.CLIENT)
public class SmartTextureManager {
    private static final SmartTextureManager INSTANCE = new SmartTextureManager();
    protected final IdentityHashMap<Object, SmartTexture> textures = new IdentityHashMap();

    public static SmartTextureManager getInstance() {
        return INSTANCE;
    }

    public synchronized void start() {
    }

    public synchronized void stop() {
        this.textures.values().forEach(SmartTexture::unbind);
        this.textures.clear();
    }

    public void open(IRenderType renderType) {
        SmartTexture texture = SmartTexture.of(renderType);
        if (texture != null) {
            texture.retain();
        }
    }

    public void close(IRenderType renderType) {
        SmartTexture texture = SmartTexture.of(renderType);
        if (texture != null) {
            texture.release();
        }
    }

    public synchronized IRenderType register(SkinTextureData provider, SkinGeometryType type) {
        SmartTexture texture = this.textures.get(provider);
        if (texture == null) {
            texture = new SmartTexture(provider);
            this.textures.put(provider, texture);
        }
        return texture.renderType(type);
    }

    public class_1060 textureManager() {
        return EnvironmentManager.getClient().method_1531();
    }

    protected void uploadTexture(SmartTexture texture) {
        OpenResourceLocation location = texture.location();
        this.textureManager().method_4616(location.toLocation(), (class_1044)AbstractSimpleTexture.create(location));
        if (ModConfig.Client.enableResourceDebug) {
            ModLog.debug("Registering Texture '{}'", location);
        }
    }

    protected void releaseTexture(SmartTexture texture) {
        OpenResourceLocation location = texture.location();
        UnregisteringAPI.unregister(this.textureManager(), location.toLocation());
        if (ModConfig.Client.enableResourceDebug) {
            ModLog.debug("Unregistering Texture '{}'", location);
        }
    }
}

