/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.ticket;

import java.util.HashMap;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;

public class TicketHolder {
    private final String name;
    private final float priority;
    private final int interval;
    private final HashMap<String, Entry> tickets = new HashMap();

    public TicketHolder(String name) {
        this(name, 0, 0.0f);
    }

    public TicketHolder(String name, float priority) {
        this(name, 0, priority);
    }

    public TicketHolder(String name, int interval, float priority) {
        this.name = name;
        this.interval = interval;
        this.priority = priority;
    }

    public Ticket<String> get(String identifier) {
        Entry ticket = this.tickets.computeIfAbsent(identifier, this::create);
        ticket.update();
        return ticket;
    }

    public Ticket<String> get(SkinDescriptor descriptor) {
        return this.get(descriptor.identifier());
    }

    public void invalidate() {
        this.tickets.values().forEach(Entry::invalidate);
        this.tickets.clear();
    }

    private Entry create(String identifier) {
        if (this.interval != 0) {
            return new TimeLimitedEntry(identifier);
        }
        return new Entry(identifier);
    }

    private class Entry
    implements Ticket<String> {
        private final String key;
        private boolean valid = false;

        private Entry(String key) {
            this.key = key;
        }

        protected void update() {
            this.valid = true;
        }

        protected void invalidate() {
            this.valid = false;
        }

        protected boolean check() {
            return this.valid;
        }

        @Override
        public float priority() {
            return TicketHolder.this.priority;
        }

        @Override
        public boolean invalid() {
            return !this.check();
        }

        @Override
        public String get() {
            return this.key;
        }

        public String toString() {
            return String.format("[%s.%s@%.1f]", TicketHolder.this.name, this.key, Float.valueOf(TicketHolder.this.priority));
        }
    }

    private class TimeLimitedEntry
    extends Entry {
        private long expiredTime;

        private TimeLimitedEntry(String key) {
            super(key);
            this.expiredTime = 0L;
        }

        @Override
        protected void update() {
            super.update();
            this.expiredTime = System.currentTimeMillis() + (long)TicketHolder.this.interval;
        }

        @Override
        protected boolean check() {
            return super.check() && this.expiredTime >= System.currentTimeMillis();
        }
    }
}

