/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;

public class SkinItem
extends class_1747
implements IItemPropertiesProvider {
    public SkinItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinSlotType slotType = SkinSlotType.byType(descriptor.type());
        if (descriptor.isEmpty() || slotType == null) {
            return class_1271.method_22430((Object)itemStack);
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((class_1297)player);
        if (wardrobe == null || !wardrobe.isEditable(player) || !wardrobe.isSupported(slotType)) {
            return class_1271.method_22430((Object)itemStack);
        }
        int slot = wardrobe.getFreeSlot(slotType);
        if (!wardrobe.getItem(slotType, slot).method_7960()) {
            return class_1271.method_22430((Object)itemStack);
        }
        if (level.method_8608()) {
            return class_1271.method_22427((Object)itemStack);
        }
        class_1799 resultStack = itemStack.method_7972();
        wardrobe.setItem(slotType, slot, resultStack.method_7971(1));
        wardrobe.broadcast();
        player.method_6122(hand, resultStack);
        return class_1271.method_22428((Object)itemStack);
    }

    public class_1269 method_7712(class_1750 context) {
        class_1799 itemStack = context.method_8041();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.type() != SkinTypes.BLOCK) {
            return class_1269.field_5811;
        }
        return super.method_7712((class_1750)new SkinBlockPlaceContext((class_1838)context));
    }

    public class_2561 method_7864(class_1799 itemStack) {
        Skin skin = SkinLoader.getInstance().getSkin(itemStack);
        if (skin != null && !skin.customName().trim().isEmpty()) {
            return TranslateUtils.formatted(skin.customName());
        }
        if (skin != null) {
            return TranslateUtils.Name.of(skin.type());
        }
        return super.method_7864(itemStack);
    }

    public String method_7876() {
        return this.method_7869();
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("loading"), (itemStack, level, entity, id) -> {
            SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
            BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(TicketManager.INVENTORY.get(descriptor));
            if (bakedSkin != null) {
                return 0.0f;
            }
            return (float)descriptor.type().id() / 1000.0f;
        });
    }
}

