/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.core.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.utils.MatrixUtils;

public class OpenMatrix3f
implements IMatrix3f {
    private static final OpenMatrix3f IDENTITY = OpenMatrix3f.createScaleMatrix(1.0f, 1.0f, 1.0f);
    public float m00;
    public float m01;
    public float m02;
    public float m10;
    public float m11;
    public float m12;
    public float m20;
    public float m21;
    public float m22;

    public OpenMatrix3f() {
    }

    public OpenMatrix3f(IMatrix3f matrix) {
        this.set(FastLocal.from(matrix));
    }

    public OpenMatrix3f(IMatrix4f matrix) {
        this.set(FastLocal.from(matrix));
    }

    public OpenMatrix3f(IQuaternionf quaternion) {
        this.set(quaternion);
    }

    public OpenMatrix3f(FloatBuffer buffer) {
        this.load(buffer);
    }

    public static OpenMatrix3f createScaleMatrix(float x, float y, float z) {
        OpenMatrix3f matrix = new OpenMatrix3f();
        matrix.m00 = x;
        matrix.m11 = y;
        matrix.m22 = z;
        return matrix;
    }

    public static OpenMatrix3f identity() {
        return IDENTITY;
    }

    public static OpenMatrix3f of(IMatrix3f mat) {
        if (mat instanceof OpenMatrix3f) {
            OpenMatrix3f that = (OpenMatrix3f)mat;
            return that;
        }
        return new OpenMatrix3f(mat);
    }

    public static OpenMatrix3f of(IMatrix4f mat) {
        return new OpenMatrix3f(mat);
    }

    @Override
    public void scale(float x, float y, float z) {
        this.multiply(OpenMatrix3f.createScaleMatrix(x, y, z));
    }

    @Override
    public void rotate(IQuaternionf other) {
        this.multiply(FastLocal.fromRot(other));
    }

    @Override
    public void set(IMatrix3f matrix) {
        this.set(FastLocal.from(matrix));
    }

    public void set(IQuaternionf q) {
        float w2 = q.w() * q.w();
        float x2 = q.x() * q.x();
        float y2 = q.y() * q.y();
        float z2 = q.z() * q.z();
        float zw = q.z() * q.w();
        float xy = q.x() * q.y();
        float xz = q.x() * q.z();
        float yw = q.y() * q.w();
        float yz = q.y() * q.z();
        float xw = q.x() * q.w();
        float dzw = zw + zw;
        float dxy = xy + xy;
        float dxz = xz + xz;
        float dyw = yw + yw;
        float dyz = yz + yz;
        float dxw = xw + xw;
        this.m00 = w2 + x2 - z2 - y2;
        this.m01 = dxy + dzw;
        this.m02 = dxz - dyw;
        this.m10 = -dzw + dxy;
        this.m11 = y2 - z2 + w2 - x2;
        this.m12 = dyz + dxw;
        this.m20 = dyw + dxz;
        this.m21 = dyz - dxw;
        this.m22 = z2 - y2 - x2 + w2;
    }

    public void set(OpenMatrix3f m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
    }

    public void set(OpenMatrix4f mat) {
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;
        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
    }

    public void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
    }

    @Override
    public void multiply(float[] values) {
        float x = values[0];
        float y = values[1];
        float z = values[2];
        values[0] = OpenMath.fma(this.m00, x, OpenMath.fma(this.m10, y, this.m20 * z));
        values[1] = OpenMath.fma(this.m01, x, OpenMath.fma(this.m11, y, this.m21 * z));
        values[2] = OpenMath.fma(this.m02, x, OpenMath.fma(this.m12, y, this.m22 * z));
    }

    @Override
    public void multiply(IMatrix3f other) {
        OpenMatrix3f.multiply(this, FastLocal.from(other), this);
    }

    public void multiplyFront(IMatrix3f other) {
        OpenMatrix3f.multiply(FastLocal.from(other), this, this);
    }

    public void multiplyFront(IQuaternionf other) {
        this.multiplyFront(FastLocal.fromRot(other));
    }

    public void multiply(float ratio) {
        this.m00 *= ratio;
        this.m01 *= ratio;
        this.m02 *= ratio;
        this.m10 *= ratio;
        this.m11 *= ratio;
        this.m12 *= ratio;
        this.m20 *= ratio;
        this.m21 *= ratio;
        this.m22 *= ratio;
    }

    @Override
    public void load(FloatBuffer buffer) {
        if (buffer.remaining() == 9) {
            this.m00 = buffer.get(OpenMatrix3f.bufferIndex(0, 0));
            this.m01 = buffer.get(OpenMatrix3f.bufferIndex(0, 1));
            this.m02 = buffer.get(OpenMatrix3f.bufferIndex(0, 2));
            this.m10 = buffer.get(OpenMatrix3f.bufferIndex(1, 0));
            this.m11 = buffer.get(OpenMatrix3f.bufferIndex(1, 1));
            this.m12 = buffer.get(OpenMatrix3f.bufferIndex(1, 2));
            this.m20 = buffer.get(OpenMatrix3f.bufferIndex(2, 0));
            this.m21 = buffer.get(OpenMatrix3f.bufferIndex(2, 1));
            this.m22 = buffer.get(OpenMatrix3f.bufferIndex(2, 2));
        } else {
            this.m00 = buffer.get(OpenMatrix3f.bufferIndex4(0, 0));
            this.m01 = buffer.get(OpenMatrix3f.bufferIndex4(0, 1));
            this.m02 = buffer.get(OpenMatrix3f.bufferIndex4(0, 2));
            this.m10 = buffer.get(OpenMatrix3f.bufferIndex4(1, 0));
            this.m11 = buffer.get(OpenMatrix3f.bufferIndex4(1, 1));
            this.m12 = buffer.get(OpenMatrix3f.bufferIndex4(1, 2));
            this.m20 = buffer.get(OpenMatrix3f.bufferIndex4(2, 0));
            this.m21 = buffer.get(OpenMatrix3f.bufferIndex4(2, 1));
            this.m22 = buffer.get(OpenMatrix3f.bufferIndex4(2, 2));
        }
    }

    @Override
    public void store(FloatBuffer buffer) {
        buffer.put(OpenMatrix3f.bufferIndex(0, 0), this.m00);
        buffer.put(OpenMatrix3f.bufferIndex(0, 1), this.m01);
        buffer.put(OpenMatrix3f.bufferIndex(0, 2), this.m02);
        buffer.put(OpenMatrix3f.bufferIndex(1, 0), this.m10);
        buffer.put(OpenMatrix3f.bufferIndex(1, 1), this.m11);
        buffer.put(OpenMatrix3f.bufferIndex(1, 2), this.m12);
        buffer.put(OpenMatrix3f.bufferIndex(2, 0), this.m20);
        buffer.put(OpenMatrix3f.bufferIndex(2, 1), this.m21);
        buffer.put(OpenMatrix3f.bufferIndex(2, 2), this.m22);
    }

    @Override
    public void invert() {
        float a = OpenMath.fma(this.m00, this.m11, -this.m01 * this.m10);
        float b = OpenMath.fma(this.m02, this.m10, -this.m00 * this.m12);
        float c = OpenMath.fma(this.m01, this.m12, -this.m02 * this.m11);
        float d = OpenMath.fma(a, this.m22, OpenMath.fma(b, this.m21, c * this.m20));
        float s = 1.0f / d;
        float nm00 = OpenMath.fma(this.m11, this.m22, -this.m21 * this.m12) * s;
        float nm01 = OpenMath.fma(this.m21, this.m02, -this.m01 * this.m22) * s;
        float nm02 = c * s;
        float nm10 = OpenMath.fma(this.m20, this.m12, -this.m10 * this.m22) * s;
        float nm11 = OpenMath.fma(this.m00, this.m22, -this.m20 * this.m02) * s;
        float nm12 = b * s;
        float nm20 = OpenMath.fma(this.m10, this.m21, -this.m20 * this.m11) * s;
        float nm21 = OpenMath.fma(this.m20, this.m01, -this.m00 * this.m21) * s;
        float nm22 = a * s;
        this.m00 = nm00;
        this.m01 = nm01;
        this.m02 = nm02;
        this.m10 = nm10;
        this.m11 = nm11;
        this.m12 = nm12;
        this.m20 = nm20;
        this.m21 = nm21;
        this.m22 = nm22;
    }

    @Override
    public void transpose() {
        float nm10 = this.m01;
        float nm12 = this.m21;
        float nm20 = this.m02;
        float nm21 = this.m12;
        this.m01 = this.m10;
        this.m02 = this.m20;
        this.m10 = nm10;
        this.m12 = nm12;
        this.m20 = nm20;
        this.m21 = nm21;
    }

    public OpenMatrix3f copy() {
        return new OpenMatrix3f(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenMatrix3f)) {
            return false;
        }
        OpenMatrix3f that = (OpenMatrix3f)o;
        if (Float.compare(that.m00, this.m00) != 0) {
            return false;
        }
        if (Float.compare(that.m11, this.m11) != 0) {
            return false;
        }
        if (Float.compare(that.m22, this.m22) != 0) {
            return false;
        }
        if (Float.compare(that.m20, this.m20) != 0) {
            return false;
        }
        if (Float.compare(that.m21, this.m21) != 0) {
            return false;
        }
        if (Float.compare(that.m01, this.m01) != 0) {
            return false;
        }
        if (Float.compare(that.m02, this.m02) != 0) {
            return false;
        }
        if (Float.compare(that.m10, this.m10) != 0) {
            return false;
        }
        return Float.compare(that.m12, this.m12) == 0;
    }

    public int hashCode() {
        int result = this.m00 != 0.0f ? Float.floatToIntBits(this.m00) : 0;
        result = 31 * result + (this.m01 != 0.0f ? Float.floatToIntBits(this.m01) : 0);
        result = 31 * result + (this.m02 != 0.0f ? Float.floatToIntBits(this.m02) : 0);
        result = 31 * result + (this.m10 != 0.0f ? Float.floatToIntBits(this.m10) : 0);
        result = 31 * result + (this.m11 != 0.0f ? Float.floatToIntBits(this.m11) : 0);
        result = 31 * result + (this.m12 != 0.0f ? Float.floatToIntBits(this.m12) : 0);
        result = 31 * result + (this.m20 != 0.0f ? Float.floatToIntBits(this.m20) : 0);
        result = 31 * result + (this.m21 != 0.0f ? Float.floatToIntBits(this.m21) : 0);
        result = 31 * result + (this.m22 != 0.0f ? Float.floatToIntBits(this.m22) : 0);
        return result;
    }

    private static int bufferIndex(int i, int j) {
        return i * 3 + j;
    }

    private static int bufferIndex4(int i, int j) {
        return i * 4 + j;
    }

    public String toString() {
        return OpenMath.format("%f %f %f\n%f %f %f\n%f %f %f\n", Float.valueOf(this.m00), Float.valueOf(this.m10), Float.valueOf(this.m20), Float.valueOf(this.m01), Float.valueOf(this.m11), Float.valueOf(this.m21), Float.valueOf(this.m02), Float.valueOf(this.m12), Float.valueOf(this.m22));
    }

    private static void multiply(OpenMatrix3f left, OpenMatrix3f right, OpenMatrix3f dest) {
        float nm00 = OpenMath.fma(left.m00, right.m00, OpenMath.fma(left.m10, right.m01, left.m20 * right.m02));
        float nm01 = OpenMath.fma(left.m01, right.m00, OpenMath.fma(left.m11, right.m01, left.m21 * right.m02));
        float nm02 = OpenMath.fma(left.m02, right.m00, OpenMath.fma(left.m12, right.m01, left.m22 * right.m02));
        float nm10 = OpenMath.fma(left.m00, right.m10, OpenMath.fma(left.m10, right.m11, left.m20 * right.m12));
        float nm11 = OpenMath.fma(left.m01, right.m10, OpenMath.fma(left.m11, right.m11, left.m21 * right.m12));
        float nm12 = OpenMath.fma(left.m02, right.m10, OpenMath.fma(left.m12, right.m11, left.m22 * right.m12));
        float nm20 = OpenMath.fma(left.m00, right.m20, OpenMath.fma(left.m10, right.m21, left.m20 * right.m22));
        float nm21 = OpenMath.fma(left.m01, right.m20, OpenMath.fma(left.m11, right.m21, left.m21 * right.m22));
        float nm22 = OpenMath.fma(left.m02, right.m20, OpenMath.fma(left.m12, right.m21, left.m22 * right.m22));
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
    }

    private static class FastLocal
    extends OpenMatrix3f {
        private static final ThreadLocal<FastLocal> LOCALS = ThreadLocal.withInitial(FastLocal::new);
        private final FloatBuffer buffer = MatrixUtils.createFloatBuffer(9);
        private final FloatBuffer buffer2 = MatrixUtils.createFloatBuffer(16);

        private FastLocal() {
        }

        private static OpenMatrix3f from(IMatrix3f value) {
            if (value instanceof OpenMatrix3f) {
                OpenMatrix3f matrix = (OpenMatrix3f)value;
                return matrix;
            }
            FastLocal local = LOCALS.get();
            value.store(local.buffer);
            local.load(local.buffer);
            return local;
        }

        private static OpenMatrix3f from(IMatrix4f value) {
            FastLocal local = LOCALS.get();
            value.store(local.buffer);
            local.load(local.buffer);
            return local;
        }

        private static OpenMatrix3f fromRot(IQuaternionf value) {
            FastLocal local = LOCALS.get();
            local.set(value);
            return local;
        }
    }
}

