/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class OpenRectangle2f {
    public static final OpenRectangle2f ZERO = new OpenRectangle2f(0.0f, 0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float width;
    public float height;

    public OpenRectangle2f(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float width() {
        return this.width;
    }

    public float height() {
        return this.height;
    }

    public float minX() {
        return this.x;
    }

    public float minY() {
        return this.y;
    }

    public float midX() {
        return this.x + this.width / 2.0f;
    }

    public float midY() {
        return this.y + this.height / 2.0f;
    }

    public float maxX() {
        return this.x + this.width;
    }

    public float maxY() {
        return this.y + this.height;
    }

    public OpenRectangle2f copy() {
        return new OpenRectangle2f(this.x, this.y, this.width, this.height);
    }

    public OpenRectangle2f scale(float s) {
        return new OpenRectangle2f(this.x * s, this.y * s, this.width * s, this.height * s);
    }

    public OpenRectangle2f offset(OpenVector2f point) {
        return this.offset(point.x(), point.y());
    }

    public OpenRectangle2f offset(float dx, float dy) {
        return new OpenRectangle2f(this.x + dx, this.y + dy, this.width, this.height);
    }

    public boolean contains(OpenVector2f point) {
        return this.contains(point.x(), point.y());
    }

    public boolean contains(float tx, float ty) {
        return this.x <= tx && tx <= this.x + this.width && this.y <= ty && ty <= this.y + this.height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenRectangle2f)) {
            return false;
        }
        OpenRectangle2f that = (OpenRectangle2f)o;
        return Float.compare(this.x, that.x) == 0 && Float.compare(this.y, that.y) == 0 && Float.compare(this.width, that.width) == 0 && Float.compare(this.height, that.height) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public String toString() {
        return OpenMath.format("(%f %f; %f %f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }
}

