/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.util.Iterator;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class OpenRectangle3i
implements IRectangle3i {
    public static final OpenRectangle3i ZERO = new OpenRectangle3i(0, 0, 0, 0, 0, 0);
    public static final IDataCodec<OpenRectangle3i> CODEC = IDataCodec.INT.listOf().xmap(OpenRectangle3i::new, OpenRectangle3i::toList);
    public int x;
    public int y;
    public int z;
    public int width;
    public int height;
    public int depth;

    public OpenRectangle3i(int x, int y, int z, int width, int height, int depth) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public OpenRectangle3i(IRectangle3i rect) {
        this(rect.x(), rect.y(), rect.z(), rect.width(), rect.height(), rect.depth());
    }

    public OpenRectangle3i(IRectangle3f rect) {
        this(OpenMath.floori(rect.x()), OpenMath.floori(rect.y()), OpenMath.floori(rect.z()), OpenMath.floori(rect.width()), OpenMath.floori(rect.height()), OpenMath.floori(rect.depth()));
    }

    public OpenRectangle3i(List<Integer> list) {
        this(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5));
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public int minX() {
        return this.x;
    }

    @Override
    public int minY() {
        return this.y;
    }

    @Override
    public int minZ() {
        return this.z;
    }

    @Override
    public int midX() {
        return this.x + this.width / 2;
    }

    @Override
    public int midY() {
        return this.y + this.height / 2;
    }

    @Override
    public int midZ() {
        return this.z + this.depth / 2;
    }

    @Override
    public int maxX() {
        return this.x + this.width;
    }

    @Override
    public int maxY() {
        return this.y + this.height;
    }

    @Override
    public int maxZ() {
        return this.z + this.depth;
    }

    public OpenVector3i origin() {
        return new OpenVector3i(this.x, this.y, this.z);
    }

    public void intersection(OpenRectangle3i rect) {
        int x1 = Math.max(this.minX(), rect.minX());
        int y1 = Math.max(this.minY(), rect.minY());
        int z1 = Math.max(this.minZ(), rect.minZ());
        int x2 = Math.min(this.maxX(), rect.maxX());
        int y2 = Math.min(this.maxY(), rect.maxY());
        int z2 = Math.min(this.maxZ(), rect.maxZ());
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.width = x2 - x1;
        this.height = y2 - y1;
        this.depth = z2 - z1;
    }

    public void union(OpenRectangle3i rect) {
        int x1 = Math.min(this.minX(), rect.minX());
        int y1 = Math.min(this.minY(), rect.minY());
        int z1 = Math.min(this.minZ(), rect.minZ());
        int x2 = Math.max(this.maxX(), rect.maxX());
        int y2 = Math.max(this.maxY(), rect.maxY());
        int z2 = Math.max(this.maxZ(), rect.maxZ());
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.width = x2 - x1;
        this.height = y2 - y1;
        this.depth = z2 - z1;
    }

    public boolean contains(OpenVector3i point) {
        int x = point.x();
        int y = point.y();
        int z = point.z();
        return this.minX() <= x && x <= this.maxX() && this.minY() <= y && y <= this.maxY() && this.minZ() <= z && z <= this.maxZ();
    }

    public OpenRectangle3i offset(OpenVector3i point) {
        return this.offset(point.x(), point.y(), point.z());
    }

    public OpenRectangle3i offset(int tx, int ty, int tz) {
        return new OpenRectangle3i(this.x + tx, this.y + ty, this.z + tz, this.width, this.height, this.depth);
    }

    public Iterable<OpenVector3i> enumerateZYX() {
        return () -> new Iterator<OpenVector3i>(){
            int ix = 0;
            int iy = 0;
            int iz = 0;

            @Override
            public boolean hasNext() {
                return this.ix < OpenRectangle3i.this.width && this.iy < OpenRectangle3i.this.height && this.iz < OpenRectangle3i.this.depth;
            }

            @Override
            public OpenVector3i next() {
                int dx = this.ix + OpenRectangle3i.this.x;
                int dy = this.iy + OpenRectangle3i.this.y;
                int dz = this.iz + OpenRectangle3i.this.z;
                ++this.iz;
                if (this.iz >= OpenRectangle3i.this.depth) {
                    this.iz = 0;
                    ++this.iy;
                }
                if (this.iy >= OpenRectangle3i.this.height) {
                    this.iy = 0;
                    ++this.ix;
                }
                return new OpenVector3i(dx, dy, dz);
            }
        };
    }

    public List<Integer> toList() {
        return Collections.newList(this.x, this.y, this.z, this.width, this.height, this.depth);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenRectangle3i)) {
            return false;
        }
        OpenRectangle3i that = (OpenRectangle3i)o;
        return this.x == that.x && this.y == that.y && this.z == that.z && this.width == that.width && this.height == that.height && this.depth == that.depth;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.width, this.height, this.depth);
    }

    public String toString() {
        return OpenMath.format("(%d %d %d; %d %d %d)", this.x, this.y, this.z, this.width, this.height, this.depth);
    }
}

