/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.utils.Executors;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class CustomReplyPacket<R>
extends CustomPacket {
    private final int id;
    private final IEntitySerializer<R> serializer;

    public CustomReplyPacket(IEntitySerializer<R> serializer) {
        this.id = Receiver.COUNTER.getAndIncrement();
        this.serializer = serializer;
    }

    public CustomReplyPacket(IEntitySerializer<R> serializer, IFriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.serializer = serializer;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
    }

    public void accept(IServerPacketHandler packetHandler, class_3222 player, IResultHandler<R> reply) {
        throw new UnsupportedOperationException("This packet (" + this.packetId() + ") does not implement a server side handler.");
    }

    public void accept(IClientPacketHandler packetHandler, class_1657 player, IResultHandler<R> reply) {
        throw new UnsupportedOperationException("This packet (" + this.packetId() + ") does not implement a client side handler.");
    }

    @Override
    public final void accept(IServerPacketHandler packetHandler, class_3222 player) {
        this.accept(packetHandler, player, (R result, Exception exception) -> NetworkManager.sendTo(new Receiver<Object>(this.id, result, exception, this), player));
    }

    @Override
    public final void accept(IClientPacketHandler packetHandler, class_1657 player) {
        this.accept(packetHandler, player, (R result, Exception exception) -> NetworkManager.sendToServer(new Receiver<Object>(this.id, result, exception, this)));
    }

    static {
        CustomPacket.register(Integer.MAX_VALUE, Receiver.class, Receiver::new);
    }

    public static class Receiver<R>
    extends CustomPacket {
        private static final AtomicInteger COUNTER = new AtomicInteger(1000);
        private static final ScheduledExecutorService TIMER = Executors.newSingleThreadScheduledExecutor();
        private static final HashMap<Integer, Request<?>> REQUESTS = new HashMap();
        private final int id;
        private final R result;
        private final Exception exception;
        private final Request<R> request;

        public Receiver(int id, R result, Exception exception, CustomReplyPacket<R> packet) {
            this.id = id;
            this.result = result;
            this.exception = exception;
            this.request = new Request<R>(packet, null);
        }

        public Receiver(IFriendlyByteBuf buffer) {
            this.id = buffer.readInt();
            this.request = this.popPendingRequest();
            if (buffer.readBoolean()) {
                this.result = Request.read(this.request, buffer);
                this.exception = null;
            } else {
                this.result = null;
                this.exception = DataSerializers.EXCEPTION.read(buffer);
            }
        }

        public static <R> void listen(CustomReplyPacket<R> packet, IResultHandler<R> handler) {
            int id = packet.id;
            int timeout = 30;
            REQUESTS.put(id, new Request<R>(packet, handler));
            TIMER.scheduleAtFixedRate(() -> {
                Request<?> request = REQUESTS.remove(id);
                if (request != null && request.handler != null) {
                    request.handler.abort(new RuntimeException("Request timeout"));
                }
            }, timeout, timeout, TimeUnit.SECONDS);
        }

        @Override
        public void encode(IFriendlyByteBuf buffer) {
            buffer.writeInt(this.id);
            if (this.result != null) {
                buffer.writeBoolean(true);
                Request.write(this.request, buffer, this.result);
            } else {
                buffer.writeBoolean(false);
                DataSerializers.EXCEPTION.write(buffer, this.exception);
            }
        }

        @Override
        public void accept(IServerPacketHandler packetHandler, class_3222 player) {
            if (this.request != null && this.request.handler != null) {
                this.request.handler.apply(this.result, this.exception);
            }
        }

        @Override
        public void accept(IClientPacketHandler packetHandler, class_1657 player) {
            if (this.request != null && this.request.handler != null) {
                this.request.handler.apply(this.result, this.exception);
            }
        }

        private Request<R> popPendingRequest() {
            Request<?> req = REQUESTS.remove(this.id);
            if (req != null) {
                return (Request)Objects.unsafeCast(req);
            }
            return null;
        }
    }

    public static class Request<R> {
        public final IEntitySerializer<R> serializer;
        public final IResultHandler<R> handler;

        public Request(CustomReplyPacket<R> packet, IResultHandler<R> handler) {
            this.handler = handler;
            this.serializer = Optional.of(packet).map(f -> f.serializer).orElse(null);
        }

        public static <R> R read(Request<R> request, IFriendlyByteBuf buf) {
            if (request != null && request.serializer != null) {
                return request.serializer.read(buf);
            }
            return null;
        }

        public static <R> void write(Request<R> request, IFriendlyByteBuf buf, R result) {
            if (request != null && request.serializer != null) {
                request.serializer.write(buf, result);
            }
        }
    }
}

