/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.common.IConfigurableTool;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class UpdateConfigurableToolPacket
extends CustomPacket {
    private final class_1268 hand;
    private final class_1799 itemStack;

    public UpdateConfigurableToolPacket(IFriendlyByteBuf buffer) {
        this.hand = buffer.readEnum(class_1268.class);
        this.itemStack = buffer.readItem();
    }

    public UpdateConfigurableToolPacket(class_1268 hand, class_1799 itemStack) {
        this.hand = hand;
        this.itemStack = itemStack;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum<?>)this.hand);
        buffer.writeItem(this.itemStack);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, class_3222 player) {
        class_1799 oldItemStack = player.method_5998(this.hand);
        if (!(oldItemStack.method_7909() instanceof IConfigurableTool)) {
            this.abort((class_1657)player, "update", "tried change unsupported item type.");
            return;
        }
        if (!oldItemStack.method_7909().equals(this.itemStack.method_7909())) {
            this.abort((class_1657)player, "update", "tried change item type.");
            return;
        }
        class_1799 newItemStack = oldItemStack.method_7972();
        this.copyTo(this.itemStack, newItemStack, (IDataComponentType)ModDataComponents.TOOL_OPTIONS.get());
        this.copyTo(this.itemStack, newItemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
        player.method_6122(this.hand, newItemStack);
    }

    private <T> void copyTo(class_1799 fromItemStack, class_1799 toItemStack, IDataComponentType<T> key) {
        T value = ComponentAPI.get(fromItemStack, key);
        ComponentAPI.set(toItemStack, key, value);
    }

    private void abort(class_1657 player, String op, String reason) {
        ModLog.info("abort {} request of the '{}', reason: '{}', from: '{}', to: '{}'", op, player.method_5820(), reason, player.method_5998(this.hand), this.itemStack);
    }
}

