/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.document;

import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentAnimation;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListeners;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentSettings;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentTypes;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import net.minecraft.class_2487;

public class SkinDocument {
    private SkinDocumentType type;
    private SkinDocumentNode nodes;
    private List<SkinDocumentAnimation> animations;
    private SkinProperties properties = new SkinProperties();
    private SkinDocumentSettings settings = new SkinDocumentSettings();
    private final SkinDocumentListeners.Proxy listener = new SkinDocumentListeners.Proxy();

    public SkinDocument() {
        this.setType(SkinDocumentTypes.GENERAL_ARMOR_HEAD);
    }

    public void reset() {
        this.nodes = this._generateDefaultNode(this.type);
        this.animations = null;
        this.settings = this._generateSkinSettings();
        this.settings.setListener(this.listener);
        this.nodes.setListener(this.listener);
        this.listener.documentDidChangeType(this.type);
    }

    public void setType(SkinDocumentType type) {
        this.type = type;
        this.properties = this._generateSkinProperties();
        this.reset();
    }

    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.TYPE, this.type);
        serializer.write(CodingKeys.NODES, this.nodes);
        serializer.write(CodingKeys.ANIMATIONS, this.animations);
        serializer.write(CodingKeys.SETTINGS, this.settings);
        serializer.write(CodingKeys.PROPERTIES, this.properties);
    }

    public void deserialize(IDataSerializer serializer) {
        this.type = serializer.read(CodingKeys.TYPE);
        this.settings = serializer.read(CodingKeys.SETTINGS);
        this.properties = serializer.read(CodingKeys.PROPERTIES);
        this.nodes = serializer.read(CodingKeys.NODES);
        if (this.nodes == null) {
            this.nodes = this._generateDefaultNode(this.type);
        }
        this.animations = serializer.read(CodingKeys.ANIMATIONS);
        this.settings.setListener(this.listener);
        this.nodes.setListener(this.listener);
        this.listener.documentDidReload();
    }

    public void updateSettings(class_2487 tag) {
        this.settings.applyChanges(tag);
        this.listener.documentDidChangeSettings(tag);
    }

    public void updateProperties(class_2487 value) {
        this.properties.putAll(new SkinProperties(value));
        this.listener.documentDidChangeProperties(value);
    }

    public <T> void put(ISkinProperty<T> property, T value) {
        this.properties.put(property, value);
        SkinProperties.Increment changes = new SkinProperties.Increment();
        changes.put(property, value);
        this.listener.documentDidChangeProperties(changes.serializeNBT());
    }

    public <T> T get(ISkinProperty<T> property) {
        return this.properties.get(property);
    }

    public void beginEditing() {
        this.listener.documentWillBeginEditing();
    }

    public void endEditing() {
        this.listener.documentDidEndEditing();
    }

    public void addListener(SkinDocumentListener listener) {
        this.listener.addListener(listener);
    }

    public void removeListener(SkinDocumentListener listener) {
        this.listener.removeListener(listener);
    }

    public void setAnimations(List<SkinDocumentAnimation> animations) {
        this.animations = animations;
    }

    public List<SkinDocumentAnimation> animations() {
        return this.animations;
    }

    public void setItemTransforms(OpenItemTransforms itemTransforms) {
        this.settings.setItemTransforms(itemTransforms);
    }

    public OpenItemTransforms itemTransforms() {
        return this.settings.itemTransforms();
    }

    public SkinDocumentListener handler() {
        return this.listener;
    }

    public SkinDocumentNode nodeById(String id) {
        return this._findNodeById(this.nodes, id);
    }

    public SkinDocumentNode root() {
        return this.nodes;
    }

    public SkinDocumentSettings settings() {
        return this.settings;
    }

    public SkinProperties properties() {
        return this.properties;
    }

    public SkinDocumentType type() {
        return this.type;
    }

    public String toString() {
        return Objects.toString(this, "type", this.type);
    }

    private SkinDocumentNode _findNodeById(SkinDocumentNode parent, String id) {
        if (id.equals(parent.id())) {
            return parent;
        }
        for (SkinDocumentNode node : parent.children()) {
            SkinDocumentNode result = this._findNodeById(node, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private SkinDocumentSettings _generateSkinSettings() {
        SkinDocumentSettings settings1 = new SkinDocumentSettings();
        settings1.setShowsOrigin(this.settings.showsOrigin());
        settings1.setShowsHelperModel(this.settings.showsHelperModel());
        return settings1;
    }

    private SkinProperties _generateSkinProperties() {
        String name = this.properties.get(SkinProperty.ALL_CUSTOM_NAME);
        String flavour = this.properties.get(SkinProperty.ALL_FLAVOUR_TEXT);
        SkinProperties properties = new SkinProperties();
        properties.put(SkinProperty.ALL_CUSTOM_NAME, name);
        properties.put(SkinProperty.ALL_FLAVOUR_TEXT, flavour);
        return properties;
    }

    private SkinDocumentNode _generateDefaultNode(SkinDocumentType category) {
        SkinDocumentNode root = new SkinDocumentNode("root", null);
        for (SkinPartType skinPartType : category.skinPartTypes()) {
            SkinDocumentNode node = new SkinDocumentNode(skinPartType.registryName().path(), null);
            node.setType(skinPartType);
            root.add(node);
        }
        root.add(new SkinDocumentNode("float", null, SkinPartTypes.ADVANCED_FLOAT));
        root.add(new SkinDocumentNode("static", null, SkinPartTypes.ADVANCED_STATIC));
        return root;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<SkinDocumentType> TYPE = IDataSerializerKey.create("Type", SkinDocumentTypes.CODEC, SkinDocumentTypes.GENERAL_ARMOR_HEAD);
        public static final IDataSerializerKey<SkinDocumentNode> NODES = IDataSerializerKey.create("Nodes", SkinDocumentNode.CODEC, null);
        public static final IDataSerializerKey<List<SkinDocumentAnimation>> ANIMATIONS = IDataSerializerKey.create("Animations", SkinDocumentAnimation.CODEC.listOf(), null);
        public static final IDataSerializerKey<SkinDocumentSettings> SETTINGS = IDataSerializerKey.create("Settings", SkinDocumentSettings.CODEC, null, SkinDocumentSettings::new);
        public static final IDataSerializerKey<SkinProperties> PROPERTIES = IDataSerializerKey.create("Properties", SkinProperties.CODEC, SkinProperties.EMPTY, SkinProperties.EMPTY::copy);

        private CodingKeys() {
        }
    }
}

