/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.ABI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.data.slot.ItemOverrideType;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.network.UpdateAnimationPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.serializer.exporter.SkinExportManager;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.command.ColorArgumentType;
import moe.plushie.armourers_workshop.init.command.ColorSchemeArgumentType;
import moe.plushie.armourers_workshop.init.command.FileArgumentType;
import moe.plushie.armourers_workshop.init.command.ListArgumentType;
import moe.plushie.armourers_workshop.init.command.ReflectArgumentBuilder;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.event.common.RegisterCommandsEvent;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ModCommands {
    private static final Map<String, SkinPaintType> DYE_TYPES = Collections.immutableMap(it -> {
        for (int i = 0; i < 8; ++i) {
            SkinPaintType paintType = SkinPaintTypes.byId(i + 1);
            String name = paintType.registryName().path();
            it.put((Object)name.replaceAll("_", ""), (Object)paintType);
        }
    });
    private static final DynamicCommandExceptionType ERROR_NOT_ENOUGH_SLOT = new DynamicCommandExceptionType(ob -> class_2561.method_43469((String)"commands.armourers_workshop.armourers.error.notEnoughSlot", (Object[])new Object[]{ob}));
    private static final DynamicCommandExceptionType ERROR_NOT_RUNNING_IN_SERVER = new DynamicCommandExceptionType(ob -> class_2561.method_43471((String)"commands.armourers_workshop.armourers.error.notRunningInServer"));
    private static final DynamicCommandExceptionType ERROR_MISSING_DYE_SLOT = new DynamicCommandExceptionType(ob -> class_2561.method_43469((String)"commands.armourers_workshop.armourers.error.missingDyeSlot", (Object[])new Object[]{ob}));
    private static final DynamicCommandExceptionType ERROR_MISSING_SKIN = new DynamicCommandExceptionType(ob -> class_2561.method_43469((String)"commands.armourers_workshop.armourers.error.missingSkin", (Object[])new Object[]{ob}));
    private static final DynamicCommandExceptionType ERROR_NOT_FOUND_SKIN = new DynamicCommandExceptionType(ob -> class_2561.method_43469((String)"commands.armourers_workshop.armourers.error.notFoundSkin", (Object[])new Object[]{ob}));
    private static final DynamicCommandExceptionType ERROR_MISSING_ITEM_STACK = new DynamicCommandExceptionType(ob -> class_2561.method_43469((String)"commands.armourers_workshop.armourers.error.missingItemSkinnable", (Object[])new Object[]{ob}));

    public static void init(RegisterCommandsEvent event) {
        event.register(ModCommands.commands());
    }

    public static LiteralArgumentBuilder<class_2168> commands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.literal("armourers").then(ReflectArgumentBuilder.literal("config", ModConfig.Client.class))).then(ReflectArgumentBuilder.literal("debug", ModDebugger.class))).requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)ModCommands.literal("library").then(ModCommands.literal("reload").executes(Executor::reloadLibrary))).then(ModCommands.literal("auth").executes(Executor::printPrivateKey)))).then(ModCommands.literal("setSkin").then(ModCommands.entities().then(ModCommands.slotNames().then(ModCommands.slots().then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::setSkin)).executes(Executor::setSkin))).then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::setSkin)).executes(Executor::setSkin)))))).then(ModCommands.literal("giveSkin").then(ModCommands.players().then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::giveSkin)).executes(Executor::giveSkin))))).then(ModCommands.literal("clearSkin").then(ModCommands.entities().then(ModCommands.slotNames().then(ModCommands.slots().executes(Executor::clearSkin))).executes(Executor::clearSkin)))).then(ModCommands.literal("exportSkin").then(ModCommands.skinFormats().then(ModCommands.name().then(ModCommands.scale().executes(Executor::exportSkin)).executes(Executor::exportSkin))))).then(ModCommands.literal("setColor").then(ModCommands.entities().then(ModCommands.dyesSlotNames().then(ModCommands.dyeColor().executes(Executor::setColor)))))).then(ModCommands.literal("rsyncWardrobe").then(ModCommands.players().executes(Executor::resyncWardrobe)))).then(ModCommands.literal("openWardrobe").then(ModCommands.entities().executes(Executor::openWardrobe)))).then(ModCommands.literal("itemSkinnable").then(ModCommands.addOrRemove().then(ModCommands.overrideTypes().executes(Executor::setItemSkinnable))))).then(ModCommands.literal("animation", "<entity_block_target>", ModCommands::animationCommands))).then(ModCommands.literal("setUnlockedSlots").then(ModCommands.entities().then(ModCommands.resizableSlotNames().then(ModCommands.resizableSlotAmounts().executes(Executor::setUnlockedWardrobeSlots)))));
    }

    static LiteralArgumentBuilder<class_2168> literal(String name) {
        return class_2170.method_9247((String)name);
    }

    static ArgumentBuilder<class_2168, ?> literal(String name, String desc, Function<ArgumentBuilder<class_2168, ?>, ArgumentBuilder<class_2168, ?>> transformer) {
        return ((LiteralArgumentBuilder)ModCommands.literal(name).then(ModCommands.literal("entity").then(transformer.apply(ModCommands.entities())))).then(ModCommands.literal("block").then(transformer.apply(ModCommands.blockPos())));
    }

    static ArgumentBuilder<class_2168, ?> animationCommands(ArgumentBuilder<class_2168, ?> parent) {
        return parent.then(ModCommands.literal("play").then(ModCommands.name().then(ModCommands.properties().executes(Executor::playAnimation)).executes(Executor::playAnimation))).then(((LiteralArgumentBuilder)ModCommands.literal("stop").then(ModCommands.name().executes(Executor::stopAnimation))).executes(Executor::stopAnimation)).then(ModCommands.literal("map").then(ModCommands.string("from").then(ModCommands.string("to").executes(Executor::mappingAnimation))));
    }

    static ArgumentBuilder<class_2168, ?> players() {
        return class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308());
    }

    static ArgumentBuilder<class_2168, ?> entities() {
        return class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306());
    }

    static ArgumentBuilder<class_2168, ?> blockPos() {
        return class_2170.method_9244((String)"block_pos", (ArgumentType)class_2262.method_9698());
    }

    static ArgumentBuilder<class_2168, ?> string(String name) {
        return class_2170.method_9244((String)name, (ArgumentType)StringArgumentType.string());
    }

    static ArgumentBuilder<class_2168, ?> slots() {
        return class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1));
    }

    static ArgumentBuilder<class_2168, ?> skinFormats() {
        return class_2170.method_9244((String)"format", (ArgumentType)ListArgumentType.list(SkinExportManager.allExporters()));
    }

    static ArgumentBuilder<class_2168, ?> skinDying() {
        return class_2170.method_9244((String)"dying", (ArgumentType)new ColorSchemeArgumentType());
    }

    static ArgumentBuilder<class_2168, ?> dyesSlotNames() {
        return class_2170.method_9244((String)"dye_slot", (ArgumentType)new ListArgumentType(DYE_TYPES.keySet()));
    }

    static ArgumentBuilder<class_2168, ?> dyeColor() {
        return class_2170.method_9244((String)"color", (ArgumentType)new ColorArgumentType());
    }

    static ArgumentBuilder<class_2168, ?> scale() {
        return class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg());
    }

    static ArgumentBuilder<class_2168, ?> name() {
        return class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string());
    }

    static ArgumentBuilder<class_2168, ?> properties() {
        return class_2170.method_9244((String)"properties", (ArgumentType)class_2179.method_9284());
    }

    static ArgumentBuilder<class_2168, ?> resizableSlotAmounts() {
        return class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10));
    }

    static ArgumentBuilder<class_2168, ?> resizableSlotNames() {
        return class_2170.method_9244((String)"slot_name", (ArgumentType)new ListArgumentType(Collections.compactMap(SkinSlotType.values(), slotType -> {
            if (slotType.isResizable()) {
                return slotType.serializedName();
            }
            return null;
        })));
    }

    static ArgumentBuilder<class_2168, ?> slotNames() {
        return class_2170.method_9244((String)"slot_name", (ArgumentType)new ListArgumentType(Collections.compactMap(SkinSlotType.values(), SkinSlotType::serializedName)));
    }

    static ArgumentBuilder<class_2168, ?> overrideTypes() {
        return class_2170.method_9244((String)"skin_type", (ArgumentType)new ListArgumentType(Collections.compactMap(ItemOverrideType.values(), ItemOverrideType::serializedName)));
    }

    static ArgumentBuilder<class_2168, ?> skins() {
        return class_2170.method_9244((String)"skin", (ArgumentType)new FileArgumentType(EnvironmentManager.getSkinLibraryDirectory()));
    }

    static ArgumentBuilder<class_2168, ?> addOrRemove() {
        return class_2170.method_9244((String)"operator", (ArgumentType)new ListArgumentType(Collections.newList("add", "remove")));
    }

    private static class Executor {
        private Executor() {
        }

        static int printPrivateKey(CommandContext<class_2168> context) throws CommandSyntaxException {
            SkinLibraryManager.Server server = SkinLibraryManager.getServer();
            if (!server.isRunning()) {
                throw ERROR_NOT_RUNNING_IN_SERVER.create(null);
            }
            String token = server.privateKey();
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43469((String)"commands.armourers_workshop.armourers.library.printToken", (Object[])new Object[]{token}), true);
            return 0;
        }

        static int reloadLibrary(CommandContext<class_2168> context) throws CommandSyntaxException {
            SkinLibraryManager.getServer().start();
            return 0;
        }

        static boolean containsNode(CommandContext<class_2168> context, String name) {
            for (ParsedCommandNode node : context.getNodes()) {
                if (!name.equals(node.getNode().getName())) continue;
                return true;
            }
            return false;
        }

        static int setColor(CommandContext<class_2168> context) throws CommandSyntaxException {
            SkinPaintType paintType = DYE_TYPES.get(ListArgumentType.getString(context, "dye_slot"));
            if (paintType == null) {
                throw ERROR_MISSING_DYE_SLOT.create(null);
            }
            SkinPaintColor paintColor = ColorArgumentType.getColor(context, "color");
            for (class_1297 entity : class_2186.method_9317(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                int slot = SkinSlotType.getDyeSlotIndex(paintType);
                class_1799 itemStack = new class_1799((class_1935)ModItems.BOTTLE.get());
                ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), paintColor);
                class_1263 inventory = wardrobe.inventory();
                inventory.method_5447(slot, itemStack);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int giveSkin(CommandContext<class_2168> context) throws CommandSyntaxException {
            SkinDescriptor descriptor = Executor.loadSkinDescriptor(context);
            class_1799 itemStack = descriptor.asItemStack();
            for (class_1657 player : class_2186.method_9312(context, (String)"targets")) {
                ABI.giveItem(player, itemStack);
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43469((String)"commands.give.success.single", (Object[])new Object[]{1, itemStack.method_7954(), player.method_5476()}), true);
            }
            return 1;
        }

        static int setSkin(CommandContext<class_2168> context) throws CommandSyntaxException {
            SkinDescriptor descriptor = Executor.loadSkinDescriptor(context);
            class_1799 itemStack = descriptor.asItemStack();
            for (class_1297 entity : class_2186.method_9317(context, (String)"entities")) {
                SkinSlotType slotType;
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null || (slotType = SkinSlotType.byName(ListArgumentType.getString(context, "slot_name"))) == null) continue;
                int slot = wardrobe.getFreeSlot(slotType);
                if (Executor.containsNode(context, "slot")) {
                    slot = IntegerArgumentType.getInteger(context, (String)"slot") - 1;
                }
                if (slot > slotType.maxSize()) {
                    throw ERROR_NOT_ENOUGH_SLOT.create((Object)slotType.maxSize());
                }
                wardrobe.setItem(slotType, slot, itemStack);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int clearSkin(CommandContext<class_2168> context) throws CommandSyntaxException {
            for (class_1297 entity : class_2186.method_9317(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                if (!Executor.containsNode(context, "slot")) {
                    wardrobe.clear();
                    wardrobe.broadcast();
                    continue;
                }
                int slot = IntegerArgumentType.getInteger(context, (String)"slot");
                SkinSlotType slotType = SkinSlotType.byName(ListArgumentType.getString(context, "slot_name"));
                if (slotType == null) continue;
                if (slot > slotType.maxSize()) {
                    throw ERROR_NOT_ENOUGH_SLOT.create((Object)slotType.maxSize());
                }
                wardrobe.setItem(slotType, slot - 1, class_1799.field_8037);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int exportSkin(CommandContext<class_2168> context) throws CommandSyntaxException {
            String format = ListArgumentType.getString(context, "format");
            String filename = StringArgumentType.getString(context, (String)"name");
            float scale = 1.0f;
            if (Executor.containsNode(context, "scale")) {
                scale = FloatArgumentType.getFloat(context, (String)"scale");
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_1799 itemStack = player.method_6047();
            String identifier = SkinDescriptor.of(itemStack).identifier();
            Skin skin = SkinLoader.getInstance().loadSkin(identifier);
            if (skin == null) {
                throw ERROR_MISSING_SKIN.create((Object)identifier);
            }
            float resolvedScale = scale;
            class_2487 tag = new class_2487();
            tag.method_10582("Skin", identifier);
            if (!skin.settings().isExportable()) {
                player.method_43496((class_2561)class_2561.method_43469((String)"commands.armourers_workshop.armourers.error.notExportInServer", (Object[])new Object[]{identifier}));
                UserNotifications.sendSystemToast((class_2561)class_2561.method_43469((String)"commands.armourers_workshop.armourers.error.notExportInServer", (Object[])new Object[]{identifier}), tag, (class_1657)player);
                return 0;
            }
            player.method_43496((class_2561)class_2561.method_43469((String)"commands.armourers_workshop.armourers.exportSkin.processing", (Object[])new Object[]{filename}));
            UserNotifications.sendSystemToast((class_2561)class_2561.method_43471((String)"commands.armourers_workshop.notify.exportSkin.processing"), tag, (class_1657)player);
            EnvironmentExecutor.runOnBackground(() -> () -> {
                try {
                    SkinExportManager.exportSkin(skin, format, filename, resolvedScale);
                    player.method_43496((class_2561)class_2561.method_43469((String)"commands.armourers_workshop.armourers.exportSkin.success", (Object[])new Object[]{filename}));
                    UserNotifications.sendSystemToast((class_2561)class_2561.method_43471((String)"commands.armourers_workshop.notify.exportSkin.success"), tag, (class_1657)player);
                }
                catch (Exception e) {
                    player.method_43496((class_2561)class_2561.method_43469((String)"commands.armourers_workshop.armourers.exportSkin.failure", (Object[])new Object[]{filename}));
                    UserNotifications.sendSystemToast((class_2561)class_2561.method_43471((String)"commands.armourers_workshop.notify.exportSkin.failure"), tag, (class_1657)player);
                    e.printStackTrace();
                }
            });
            return 0;
        }

        static int setItemSkinnable(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            String operator = ListArgumentType.getString(context, "operator");
            ItemOverrideType overrideType = ItemOverrideType.of(ListArgumentType.getString(context, "skin_type"));
            class_1799 itemStack = player.method_6047();
            if (overrideType == null || itemStack.method_7960()) {
                throw ERROR_MISSING_ITEM_STACK.create((Object)player.method_5820());
            }
            IResourceLocation identifier = TypedRegistry.findKey(itemStack.method_7909());
            String key = String.format("%s:%s", overrideType.serializedName(), identifier);
            if (operator.equals("add")) {
                if (ModConfig.Common.overrides.contains(key)) {
                    return 1;
                }
                ModConfig.Common.overrides.add(key);
            } else {
                if (!ModConfig.Common.overrides.contains(key)) {
                    return 1;
                }
                ModConfig.Common.overrides.remove(key);
            }
            ModConfigSpec.COMMON.save();
            String messageKey = "commands.armourers_workshop.armourers.setItemSkinnable." + operator;
            class_5250 overrideTypeName = TranslateUtils.Name.of(overrideType);
            player.method_43496((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{itemStack.method_7954(), overrideTypeName}));
            return 1;
        }

        static int resyncWardrobe(CommandContext<class_2168> context) throws CommandSyntaxException {
            for (class_3222 player : class_2186.method_9312(context, (String)"targets")) {
                SkinWardrobe wardrobe = SkinWardrobe.of((class_1297)player);
                if (wardrobe == null) continue;
                wardrobe.broadcast();
            }
            return 1;
        }

        static int openWardrobe(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            for (class_1297 entity : class_2186.method_9317(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                ((IMenuType)ModMenuTypes.WARDROBE_OP.get()).openMenu((class_1657)player, wardrobe);
                break;
            }
            return 1;
        }

        static int setUnlockedWardrobeSlots(CommandContext<class_2168> context) throws CommandSyntaxException {
            for (class_1297 entity : class_2186.method_9317(context, (String)"entities")) {
                SkinSlotType slotType;
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null || (slotType = SkinSlotType.byName(ListArgumentType.getString(context, "slot_name"))) == null) continue;
                int amount = IntegerArgumentType.getInteger(context, (String)"amount");
                wardrobe.setUnlockedSize(slotType, OpenMath.clamp(amount, 0, slotType.maxSize()));
                wardrobe.broadcast();
            }
            return 1;
        }

        static SkinDescriptor loadSkinDescriptor(CommandContext<class_2168> context) throws CommandSyntaxException {
            String identifier = FileArgumentType.getString(context, "skin");
            if (identifier.isEmpty()) {
                throw ERROR_MISSING_SKIN.create((Object)identifier);
            }
            SkinPaintScheme scheme = SkinPaintScheme.EMPTY;
            if (Executor.containsNode(context, "dying")) {
                scheme = ColorSchemeArgumentType.getColorScheme(context, "dying");
            }
            boolean needCopy = false;
            if (identifier.startsWith("/")) {
                identifier = DataDomain.DEDICATED_SERVER.normalize(identifier);
                needCopy = true;
            }
            if (DataDomain.RESOURCE_PACK.matches(identifier)) {
                return new SkinDescriptor(identifier);
            }
            SkinDescriptor descriptor = SkinLoader.getInstance().loadSkinFromDB(identifier, scheme, needCopy);
            if (descriptor.isEmpty()) {
                throw ERROR_NOT_FOUND_SKIN.create((Object)identifier);
            }
            return descriptor;
        }

        public static int playAnimation(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_2487 properties = new class_2487();
            if (Executor.containsNode(context, "properties")) {
                properties = class_2179.method_9285(context, (String)"properties");
            }
            String animationName = StringArgumentType.getString(context, (String)"name");
            for (UpdateAnimationPacket.Selector selector : Executor.getAnimationSelector(context)) {
                NetworkManager.sendToAll(UpdateAnimationPacket.play(selector, animationName, properties));
            }
            return 0;
        }

        public static int stopAnimation(CommandContext<class_2168> context) throws CommandSyntaxException {
            String animationName = "";
            if (Executor.containsNode(context, "name")) {
                animationName = StringArgumentType.getString(context, (String)"name");
            }
            for (UpdateAnimationPacket.Selector selector : Executor.getAnimationSelector(context)) {
                NetworkManager.sendToAll(UpdateAnimationPacket.stop(selector, animationName));
            }
            return 0;
        }

        public static int mappingAnimation(CommandContext<class_2168> context) throws CommandSyntaxException {
            String from = StringArgumentType.getString(context, (String)"from");
            String to = StringArgumentType.getString(context, (String)"to");
            for (UpdateAnimationPacket.Selector selector : Executor.getAnimationSelector(context)) {
                NetworkManager.sendToAll(UpdateAnimationPacket.rewrite(selector, from, to));
            }
            return 0;
        }

        private static List<UpdateAnimationPacket.Selector> getAnimationSelector(CommandContext<class_2168> context) throws CommandSyntaxException {
            ArrayList<UpdateAnimationPacket.Selector> selectors = new ArrayList<UpdateAnimationPacket.Selector>();
            if (Executor.containsNode(context, "entities")) {
                for (class_1297 entity : class_2186.method_9317(context, (String)"entities")) {
                    selectors.add(new UpdateAnimationPacket.Selector(entity));
                }
            }
            if (Executor.containsNode(context, "block_pos")) {
                class_2338 blockPos = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.commands.arguments.coordinates.BlockPosArgument.ABI.getBlockPos(class_2262.class, context, "block_pos");
                selectors.add(new UpdateAnimationPacket.Selector(blockPos));
            }
            return selectors;
        }
    }
}

