/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class ModMenuOptions {
    private static final ModMenuOptions INSTANCE = new ModMenuOptions();
    private final File contentPath;
    private final class_2487 values = new class_2487();

    private ModMenuOptions() {
        this.contentPath = new File(EnvironmentManager.getRootDirectory(), "options.dat");
        if (this.contentPath.exists()) {
            this.load();
        }
    }

    public static ModMenuOptions getInstance() {
        return INSTANCE;
    }

    public void putString(String key, String value) {
        this.values.method_10582(key, value);
        this.setChanged();
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        return OptionalAPI.getOptionalString(this.values, key).orElse(defaultValue);
    }

    public void putInt(String key, int value) {
        this.values.method_10569(key, value);
        this.setChanged();
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        return OptionalAPI.getOptionalInt(this.values, key).orElse(defaultValue);
    }

    public void putBoolean(String key, boolean value) {
        this.values.method_10556(key, value);
        this.setChanged();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return OptionalAPI.getOptionalBoolean(this.values, key).orElse(defaultValue);
    }

    public void putTag(String key, class_2487 tag) {
        this.values.method_10566(key, (class_2520)tag);
        this.setChanged();
    }

    public class_2487 getTag(String key) {
        return OptionalAPI.getOptionalCompound(this.values, key).orElse(null);
    }

    private void load() {
        try (FileInputStream inputStream = new FileInputStream(this.contentPath);){
            class_2487 tag = TagSerializer.parse(inputStream);
            this.values.method_10543(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void save() {
        try (FileOutputStream outputStream = new FileOutputStream(this.contentPath);){
            TagSerializer.writeToStream(this.values, (OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setChanged() {
        EnvironmentExecutor.runOnBackground(() -> this::save);
    }
}

