/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.ILootFunction;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.class_1297;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_47;
import org.jetbrains.annotations.Nullable;

public class SkinRandomlyFunction
implements ILootFunction {
    public static final MapCodec<SkinRandomlyFunction> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SkinSource.MAP_CODEC.listOf().fieldOf("skins").forGetter(SkinRandomlyFunction::sources)).apply((Applicative)instance, SkinRandomlyFunction::new));
    public final List<SkinSource> sources;

    public SkinRandomlyFunction(Collection<SkinSource> sources) {
        this.sources = Collections.newList(sources);
    }

    @Override
    public class_1799 apply(class_1799 itemStack, class_47 lootContext) {
        SkinDescriptor descriptor = SkinDescriptor.EMPTY;
        ArrayList<SkinSource> pending = new ArrayList<SkinSource>(this.sources);
        while (descriptor.isEmpty() && !pending.isEmpty()) {
            int index = lootContext.method_294().method_43048(pending.size());
            descriptor = pending.remove(index).apply(lootContext);
        }
        if (descriptor.isEmpty()) {
            return class_1799.field_8037;
        }
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.SKIN.get(), descriptor);
        return itemStack;
    }

    public List<SkinSource> sources() {
        return this.sources;
    }

    public Set<class_169<?>> method_293() {
        return new HashSet(Collections.compactMap(this.sources, SkinSource::param));
    }

    public static class SkinSource
    implements IResultHandler<SkinDescriptor> {
        public static final Codec<SkinSource> MAP_CODEC = new Codec<SkinSource>(){
            final Codec<SkinSource> simple = Codec.STRING.xmap(SkinSource::new, it -> null);
            final Codec<SkinSource> complex = RecordCodecBuilder.create(instance -> instance.group((App)SkinSlotType.CODEC.fieldOf("type").forGetter(it -> null), (App)Codec.INT.optionalFieldOf("slot", (Object)0).forGetter(it -> 0)).apply((Applicative)instance, SkinSource::new));

            public <T> DataResult<Pair<SkinSource, T>> decode(DynamicOps<T> ops, T input) {
                DataResult result = this.simple.decode(ops, input);
                if (result.result().isPresent()) {
                    return result;
                }
                return this.complex.decode(ops, input);
            }

            public <T> DataResult<T> encode(SkinSource input, DynamicOps<T> ops, T prefix) {
                throw new RuntimeException("why you needs serializer?");
            }
        };
        private SkinDescriptor provider;
        private Function<class_47, SkinDescriptor> searcher;
        private class_169<?> param;

        public SkinSource(String identifier) {
            if (!identifier.isEmpty()) {
                SkinLoader.getInstance().submit(() -> SkinLoader.getInstance().loadSkinFromDB(identifier, SkinPaintScheme.EMPTY, this));
            }
        }

        public SkinSource(SkinSlotType slotType, int slot) {
            this.searcher = context -> this.search((class_47)context, slotType, slot);
            this.param = class_181.field_1226;
        }

        public SkinDescriptor apply(class_47 lootContext) {
            if (this.provider != null) {
                return this.provider;
            }
            if (this.searcher != null) {
                return this.searcher.apply(lootContext);
            }
            return SkinDescriptor.EMPTY;
        }

        @Override
        public void apply(SkinDescriptor value, Exception exception) {
            this.provider = value;
        }

        public SkinDescriptor search(class_47 lootContext, @Nullable SkinSlotType slotType, int index) {
            Object value = lootContext.method_296(this.param);
            SkinWardrobe wardrobe = SkinWardrobe.of(Objects.safeCast(value, class_1297.class));
            if (wardrobe == null) {
                return SkinDescriptor.EMPTY;
            }
            SkinDescriptor descriptor = SkinDescriptor.EMPTY;
            ArrayList<class_1799> pending = this.collect(wardrobe, slotType, index);
            while (descriptor.isEmpty() && !pending.isEmpty()) {
                index = lootContext.method_294().method_43048(pending.size());
                descriptor = SkinDescriptor.of(pending.remove(index));
            }
            return descriptor;
        }

        public ArrayList<class_1799> collect(SkinWardrobe wardrobe, @Nullable SkinSlotType slotType, int index) {
            ArrayList<class_1799> results = new ArrayList<class_1799>();
            if (slotType == null) {
                for (SkinSlotType slotType1 : SkinSlotType.values()) {
                    if (slotType1.skinType() == null) continue;
                    results.addAll(this.collect(wardrobe, slotType1, index));
                }
                return results;
            }
            if (index != 0) {
                results.add(wardrobe.getItem(slotType, index));
                return results;
            }
            int count = wardrobe.getUnlockedSize(slotType);
            for (int i = 0; i < count; ++i) {
                results.add(wardrobe.getItem(slotType, i));
            }
            return results;
        }

        public class_169<?> param() {
            return this.param;
        }
    }
}

