/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.platform.ReplayManager;
import net.minecraft.class_1657;

public class ServerReplayPacket
extends CustomPacket {
    private final Event event;
    private final ByteBuf parameters;

    public ServerReplayPacket(Event event, Consumer<IFriendlyByteBuf> consumer) {
        this.event = event;
        if (consumer != null) {
            this.parameters = Unpooled.buffer();
            consumer.accept(IFriendlyByteBuf.wrap(this.parameters));
        } else {
            this.parameters = null;
        }
    }

    public ServerReplayPacket(IFriendlyByteBuf buffer) {
        this.event = buffer.readEnum(Event.class);
        int size = buffer.readInt();
        this.parameters = size != 0 ? Unpooled.wrappedBuffer((ByteBuf)buffer.readBytes(size)) : null;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum(this.event);
        if (this.parameters != null) {
            ByteBuf buf = this.parameters.slice();
            buffer.writeInt(buf.readableBytes());
            buffer.writeBytes(buf);
        } else {
            buffer.writeInt(0);
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, class_1657 player) {
        ReplayManager.accept(this);
    }

    public Event event() {
        return this.event;
    }

    public ByteBuf parameters() {
        return this.parameters;
    }

    public static enum Event {
        START_RECORDING,
        STOP_RECORDING;

    }
}

