/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UITextFieldDelegate;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.builder.blockentity.ColorMixerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.widget.PaletteEditingWindow;
import moe.plushie.armourers_workshop.builder.data.palette.Palette;
import moe.plushie.armourers_workshop.builder.menu.ColorMixerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateColorMixerPacket;
import moe.plushie.armourers_workshop.core.client.gui.widget.HSBSliderBox;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorMixerWindow
extends PaletteEditingWindow<ColorMixerMenu>
implements UITextFieldDelegate {
    public ColorMixerWindow(ColorMixerMenu container, Inventory inventory, NSString title) {
        super(container, inventory, title);
        this.setFrame(new CGRect(0.0f, 0.0f, 256.0f, 240.0f));
        this.reloadStatus();
    }

    @Override
    public void init() {
        super.init();
        this.setupLayout();
        this.setupBackgroundView();
        this.setupPaletteViews();
        this.setupPickerViews();
        this.setSelectedColor(this.paintColorView.color());
        this.bringSubviewToFront(this.titleView);
        this.bringSubviewToFront(this.inventoryView);
    }

    @Override
    public void menuDidChange() {
        this.reloadStatus();
    }

    protected void reloadStatus() {
        ColorMixerBlockEntity blockEntity = (ColorMixerBlockEntity)((ColorMixerMenu)this.menu).getBlockEntity();
        SkinPaintColor paintColor = blockEntity.color();
        UIColor selectedColor = UIColor.of(paintColor.argb());
        SkinPaintType selectedPaintType = paintColor.paintType();
        this.paintColorView.setColor(selectedColor);
        this.paintColorView.setPaintType(selectedPaintType);
        if (this.paintComboBox == null || this.paintTypes == null) {
            return;
        }
        this.setSelectedColor(selectedColor);
        int selectedIndex = this.paintTypes.indexOf(selectedPaintType);
        if (selectedIndex >= 0) {
            this.paintComboBox.setSelectedIndex(selectedIndex);
        }
    }

    @Override
    protected void submitColorChange(UIControl control) {
        UpdateColorMixerPacket.Field<SkinPaintColor> field;
        ColorMixerBlockEntity blockEntity = (ColorMixerBlockEntity)((ColorMixerMenu)this.menu).getBlockEntity();
        SkinPaintColor paintColor = this.paintColorView.paintColor();
        if (paintColor.equals((field = UpdateColorMixerPacket.Field.COLOR).get(blockEntity))) {
            return;
        }
        NetworkManager.sendToServer(field.buildPacket(blockEntity, paintColor));
    }

    private void setupLayout() {
        this.paintColorView.setFrame(new CGRect(108.0f, 102.0f, 13.0f, 13.0f));
        this.hexInputView.setFrame(new CGRect(5.0f, 105.0f, 55.0f, 16.0f));
        this.paintComboBox.setFrame(new CGRect(164.0f, 32.0f, 86.0f, 14.0f));
        this.paletteComboBox.setFrame(new CGRect(164.0f, 62.0f, 86.0f, 14.0f));
        this.paletteBox.setFrame(new CGRect(166.0f, 80.0f, 82.0f, 42.0f));
    }

    private void setupBackgroundView() {
        this.setBackgroundView(UIImage.of(ModTextures.COLOR_MIXER).build());
        this.setupLabel(5, 21, "label.hue");
        this.setupLabel(5, 46, "label.saturation");
        this.setupLabel(5, 71, "label.brightness");
        this.setupLabel(5, 94, "label.hex");
        this.setupLabel(165, 51, "label.presets");
        this.setupLabel(165, 21, "label.paintType");
        this.addSubview(this.paintColorView);
    }

    private void setupPickerViews() {
        this.sliders[0] = this.setupHSBSlider(5, 30, HSBSliderBox.Type.HUE);
        this.sliders[1] = this.setupHSBSlider(5, 55, HSBSliderBox.Type.SATURATION);
        this.sliders[2] = this.setupHSBSlider(5, 80, HSBSliderBox.Type.BRIGHTNESS);
        this.hexInputView.setMaxLength(7);
        this.hexInputView.setContentInsets(new UIEdgeInsets(2.0f, 5.0f, 2.0f, 0.0f));
        this.hexInputView.setDelegate(this);
        this.addSubview(this.hexInputView);
        this.setupPaintList();
    }

    private void setupPaletteViews() {
        this.paletteBox.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, (rec$, x$0) -> ((ColorMixerWindow)rec$).applyPaletteChange((UIControl)x$0));
        this.addSubview(this.paletteBox);
        this.setupHelpButton(186, 130);
        this.setupButton(232, 126, 208, 176, "button.add_palette", (rec$, x$0) -> ((ColorMixerWindow)rec$).showNewPaletteDialog((UIControl)x$0));
        this.setupButton(214, 126, 208, 160, "button.remove_palette", (rec$, x$0) -> ((ColorMixerWindow)rec$).showRemovePaletteDialog((UIControl)x$0));
        this.setupButton(196, 126, 208, 192, "button.rename_palette", (rec$, x$0) -> ((ColorMixerWindow)rec$).showRenamePaletteDialog((UIControl)x$0));
        this.setupPaletteList();
    }

    private void setupLabel(int x, int y, String key) {
        UILabel label = new UILabel(new CGRect(x, y, 80.0f, 9.0f));
        label.setText(this.getDisplayText(key, new Object[0]));
        this.addSubview(label);
    }

    private void setupButton(int x, int y, int u, int v, String key, BiConsumer<ColorMixerWindow, UIControl> consumer) {
        UIButton button = new UIButton(new CGRect(x, y, 16.0f, 16.0f));
        button.setTooltip(this.getDisplayText(key, new Object[0]));
        button.setBackgroundImage(ModTextures.defaultButtonImage(u, v), 7);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, consumer);
        this.addSubview(button);
    }

    private void setupHelpButton(int x, int y) {
        UIButton button = new UIButton(new CGRect(x, y, 7.0f, 8.0f));
        button.setBackgroundImage(ModTextures.helpButtonImage(), 7);
        button.setTooltip(this.getDisplayText("help.palette", new Object[0]));
        button.setCanBecomeFocused(false);
        this.addSubview(button);
    }

    private HSBSliderBox setupHSBSlider(int x, int y, HSBSliderBox.Type type) {
        HSBSliderBox slider = new HSBSliderBox(type, new CGRect(x, y, 150.0f, 10.0f));
        slider.addTarget(this, UIControl.Event.VALUE_CHANGED, (rec$, x$0) -> ((ColorMixerWindow)rec$).applyColorChange((UIControl)x$0));
        slider.addTarget(this, UIControl.Event.EDITING_DID_END, ColorMixerWindow::submitColorChange);
        this.addSubview(slider);
        return slider;
    }

    private void setupPaintList() {
        int selectedIndex = 0;
        this.paintTypes = new ArrayList();
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        for (SkinPaintType paintType : SkinPaintTypes.values()) {
            UIComboItem item = new UIComboItem(new NSString((Component)TranslateUtils.Name.of(paintType)));
            if (paintType == SkinPaintTypes.TEXTURE) {
                item.setEnabled(false);
            }
            if (paintType == this.paintColorView.paintType()) {
                selectedIndex = items.size();
            }
            items.add(item);
            this.paintTypes.add(paintType);
        }
        this.paintComboBox.setMaxRows(5);
        this.paintComboBox.setSelectedIndex(selectedIndex);
        this.paintComboBox.reloadData(items);
        this.paintComboBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            int newValue = self.paintComboBox.selectedIndex();
            self.paintColorView.setPaintType((SkinPaintType)self.paintTypes.get(newValue));
            self.submitColorChange(null);
        });
        this.addSubview(this.paintComboBox);
    }

    private void setupPaletteList() {
        this.paletteComboBox.setMaxRows(5);
        this.paletteComboBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, view) -> {
            int newValue = ((UIComboBox)view).selectedIndex();
            self.setSelectedPalette((Palette)self.palettes.get(newValue));
        });
        this.addSubview(this.paletteComboBox);
        this.reloadPalettes();
    }

    protected NSString getDisplayText(String key, Object ... args) {
        return NSString.localizedString("colour-mixer." + key, args);
    }
}

