/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGRect;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.builder.client.gui.widget.PartItem;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinPreviewList;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PartItemList
extends SkinPreviewList<PartItem> {
    private SkinDescriptor selectedItem;

    public PartItemList(CGRect frame) {
        super(frame);
    }

    @Override
    public void renderItemContent(float x, float y, float width, float height, boolean isHovered, PartItem entry, IBufferSource bufferSource, CGGraphicsContext context) {
        this.setTooltip(this.getItemTooltip(entry, isHovered));
        if (entry == PartItem.CLEAR) {
            context.drawResizableImage(ModTextures.SKIN_PANEL, x, y, width, height, 224.0f, 0.0f, 32.0f, 32.0f, 256.0f, 256.0f);
            return;
        }
        if (entry == PartItem.IMPORT) {
            context.drawResizableImage(ModTextures.SKIN_PANEL, x, y, width, height, 224.0f, 32.0f, 32.0f, 32.0f, 256.0f, 256.0f);
            return;
        }
        super.renderItemContent(x, y, width, height, isHovered, entry, bufferSource, context);
    }

    public SkinDescriptor selectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(SkinDescriptor selectedItem) {
        this.selectedItem = selectedItem;
    }

    @Override
    protected String getItemName(PartItem value) {
        return "";
    }

    @Override
    protected SkinDescriptor getItemDescriptor(PartItem value) {
        return value.descriptor();
    }

    @Override
    protected int getItemBackgroundColor(PartItem entry, boolean isHovered) {
        if (Objects.equals(this.selectedItem(), entry.descriptor()) && entry.hasSkin()) {
            return -529041647;
        }
        return super.getItemBackgroundColor(entry, isHovered);
    }

    protected ItemStack getItemTooltip(PartItem entry, boolean isHovered) {
        if (isHovered && entry.hasItem()) {
            return entry.itemStack();
        }
        return null;
    }
}

