/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.AdvancedBuilderMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AdvancedExportPacket
extends CustomPacket {
    private final BlockPos pos;
    private final CompoundTag profileTag;

    public AdvancedExportPacket(AdvancedBuilderBlockEntity blockEntity, CompoundTag profileTag) {
        this.pos = blockEntity.m_58899_();
        this.profileTag = profileTag;
    }

    public AdvancedExportPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.profileTag = buffer.readNbt();
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeNbt(this.profileTag);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        AdvancedBuilderBlockEntity blockEntity1;
        block5: {
            block4: {
                BlockEntity blockEntity = player.m_9236_().m_7702_(this.pos);
                if (!(blockEntity instanceof AdvancedBuilderBlockEntity)) break block4;
                blockEntity1 = (AdvancedBuilderBlockEntity)blockEntity;
                if (player.f_36096_ instanceof AdvancedBuilderMenu) break block5;
            }
            this.abort((Player)player, "unauthorized", "user status is incorrect");
            return;
        }
        if (!ModPermissions.ADVANCED_SKIN_BUILDER_SKIN_EXPORT.accept((Player)player)) {
            this.abort((Player)player, "export", "prohibited by the config file");
            return;
        }
        GameProfile profile = DataSerializers.readGameProfile(this.profileTag);
        this.accept((Player)player, "export");
        blockEntity1.exportFromDocument(player, profile);
    }

    private void accept(Player player, String op) {
        String playerName = player.m_6302_();
        ModLog.info("accept {} request of the '{}'", op, playerName);
    }

    private void abort(Player player, String op, String reason) {
        String playerName = player.m_6302_();
        ModLog.info("abort {} request of the '{}', reason: '{}'", op, playerName, reason);
    }
}

