/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Constructor;
import moe.plushie.armourers_workshop.core.data.GenericProperties;
import moe.plushie.armourers_workshop.core.data.GenericProperty;
import moe.plushie.armourers_workshop.core.data.GenericValue;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.permission.BlockPermission;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateArmourerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final GenericValue<ArmourerBlockEntity, ?> fieldValue;

    public UpdateArmourerPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.fieldValue = Field.TYPE.read(buffer);
    }

    public UpdateArmourerPacket(ArmourerBlockEntity entity, GenericValue<ArmourerBlockEntity, ?> fieldValue) {
        this.pos = entity.m_58899_();
        this.fieldValue = fieldValue;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        this.fieldValue.write(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        ArmourerMenu menu1;
        Object object;
        ArmourerBlockEntity blockEntity1;
        block3: {
            block2: {
                BlockEntity blockEntity = player.m_9236_().m_7702_(this.pos);
                if (!(blockEntity instanceof ArmourerBlockEntity)) break block2;
                blockEntity1 = (ArmourerBlockEntity)blockEntity;
                object = player.f_36096_;
                if (!(object instanceof ArmourerMenu)) break block2;
                menu1 = (ArmourerMenu)((Object)object);
                object = this.fieldValue.property();
                if (object instanceof Field) break block3;
            }
            return;
        }
        Field field = (Field)object;
        BlockUtils.performBatch(() -> {
            try {
                field.apply(this, (Player)player, blockEntity1, menu1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    private void loadItem(Player player, ArmourerBlockEntity blockEntity, ArmourerMenu container, CompoundTag nbt) {
        container.loadArmourItem(player);
    }

    private void saveItem(Player player, ArmourerBlockEntity blockEntity, ArmourerMenu container, CompoundTag nbt) {
        ModLog.info("accept save action of the {}, nbt: {}", player.m_6302_(), nbt);
        GameProfile profile = DataSerializers.readGameProfile(nbt);
        container.saveArmourItem(player, profile, null, null);
    }

    private void copyItem(Player player, ArmourerBlockEntity blockEntity, ArmourerMenu container, CompoundTag nbt) throws Exception {
        ModLog.info("accept copy action of the {}, nbt: {}", player.m_6302_(), nbt);
        Boolean isMirror = OptionalAPI.getOptionalBoolean(nbt, "Mirror").orElse(false);
        Boolean isCopyPaintData = OptionalAPI.getOptionalBoolean(nbt, "Paints").orElse(false);
        SkinPartType sourcePartType = SkinPartTypes.byName(OptionalAPI.getOptionalString(nbt, "Source").orElse(""));
        SkinPartType destinationPartType = SkinPartTypes.byName(OptionalAPI.getOptionalString(nbt, "Destination").orElse(""));
        CubeChangesCollector collector = new CubeChangesCollector(blockEntity.m_58904_());
        blockEntity.copyCubes(collector, sourcePartType, destinationPartType, isMirror);
        if (isCopyPaintData.booleanValue()) {
            blockEntity.copyPaintData(collector, sourcePartType, destinationPartType, isMirror);
        }
        collector.submit((Component)Component.m_237115_((String)"action.armourers_workshop.block.copy"), player);
    }

    private void replaceItem(Player player, ArmourerBlockEntity blockEntity, ArmourerMenu container, CompoundTag nbt) throws Exception {
        ModLog.info("accept replace action of the {}, nbt: {}", player.m_6302_(), nbt);
        Level level = player.m_9236_();
        ItemStack source = OptionalAPI.getOptionalCompound(nbt, "Source").flatMap(tag -> Constructor.parse(ItemStack.class, level.m_5962_(), tag)).orElse(ItemStack.f_41583_);
        ItemStack destination = OptionalAPI.getOptionalCompound(nbt, "Destination").flatMap(tag -> Constructor.parse(ItemStack.class, level.m_5962_(), tag)).orElse(ItemStack.f_41583_);
        CubeReplacingEvent event = new CubeReplacingEvent(source, destination);
        event.keepColor = OptionalAPI.getOptionalBoolean(nbt, "KeepColor").orElse(false);
        event.keepPaintType = OptionalAPI.getOptionalBoolean(nbt, "KeepPaintType").orElse(false);
        if (event.isEmptySource && event.isEmptyDestination) {
            return;
        }
        CubeChangesCollector collector = new CubeChangesCollector(blockEntity.m_58904_());
        blockEntity.replaceCubes(collector, SkinPartTypes.UNKNOWN, event);
        collector.submit((Component)Component.m_237115_((String)"action.armourers_workshop.block.replace"), player);
        player.m_213846_((Component)Component.m_237110_((String)"inventory.armourers_workshop.armourer.dialog.replace.success", (Object[])new Object[]{collector.total()}));
    }

    private void clearItem(Player player, ArmourerBlockEntity blockEntity, ArmourerMenu container, CompoundTag nbt) {
        ModLog.info("accept clear action of the {}, nbt: {}", player.m_6302_(), nbt);
        CubeChangesCollector collector = new CubeChangesCollector(blockEntity.m_58904_());
        SkinPartType partType = OptionalAPI.getOptionalString(nbt, "PartType").map(SkinPartTypes::byName).orElse(SkinPartTypes.UNKNOWN);
        if (OptionalAPI.getOptionalBoolean(nbt, "Cubes").orElse(false).booleanValue()) {
            blockEntity.clearCubes(collector, partType);
        }
        if (OptionalAPI.getOptionalBoolean(nbt, "Paints").orElse(false).booleanValue()) {
            blockEntity.clearPaintData(collector, partType);
        }
        if (OptionalAPI.getOptionalBoolean(nbt, "Markers").orElse(false).booleanValue() && !OptionalAPI.getOptionalBoolean(nbt, "Cubes").orElse(false).booleanValue()) {
            blockEntity.clearMarkers(collector, partType);
        }
        collector.submit((Component)Component.m_237115_((String)"action.armourers_workshop.block.clear"), player);
    }

    public static final class Field<T>
    extends GenericProperty<ArmourerBlockEntity, T> {
        private static final GenericProperties<ArmourerBlockEntity> TYPE = GenericProperties.of(ArmourerBlockEntity.class, UpdateArmourerPacket::new);
        public static final Field<Integer> FLAGS = Field.create(ArmourerBlockEntity::getFlags, ArmourerBlockEntity::setFlags, DataSerializers.INT, ModPermissions.ARMOURER_SETTING);
        public static final Field<SkinType> SKIN_TYPE = Field.create(ArmourerBlockEntity::skinType, ArmourerBlockEntity::setSkinType, DataSerializers.SKIN_TYPE, ModPermissions.ARMOURER_SETTING);
        public static final Field<SkinProperties> SKIN_PROPERTIES = Field.create(ArmourerBlockEntity::skinProperties, ArmourerBlockEntity::setSkinProperties, DataSerializers.SKIN_PROPERTIES, ModPermissions.ARMOURER_SETTING);
        public static final Field<EntityTextureDescriptor> TEXTURE_DESCRIPTOR = Field.create(ArmourerBlockEntity::textureDescriptor, ArmourerBlockEntity::setTextureDescriptor, DataSerializers.PLAYER_TEXTURE, ModPermissions.ARMOURER_SETTING);
        public static final Field<EntityTextureDescriptor.Model> TEXTURE_MODEL = Field.create(ArmourerBlockEntity::textureModel, ArmourerBlockEntity::setTextureModel, DataSerializers.PLAYER_TEXTURE_MODEL, ModPermissions.ARMOURER_SETTING);
        public static final Field<CompoundTag> ITEM_CLEAR = Field.create(UpdateArmourerPacket::clearItem, DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_CLEAR);
        public static final Field<CompoundTag> ITEM_COPY = Field.create(UpdateArmourerPacket::copyItem, DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_COPY);
        public static final Field<CompoundTag> ITEM_REPLACE = Field.create(UpdateArmourerPacket::replaceItem, DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_REPLACE);
        public static final Field<CompoundTag> ITEM_LOAD = Field.create(UpdateArmourerPacket::loadItem, DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_LOAD);
        public static final Field<CompoundTag> ITEM_SAVE = Field.create(UpdateArmourerPacket::saveItem, DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_SAVE);
        private FieldAction<T> action;
        private BlockPermission permission;

        private static <T> Field<T> create(FieldAction<T> action, IEntitySerializer<T> dataSerializer, BlockPermission permission) {
            Field field = TYPE.create(dataSerializer).build(Field::new);
            field.action = action;
            field.permission = permission;
            return field;
        }

        private static <T> Field<T> create(Function<ArmourerBlockEntity, T> supplier, BiConsumer<ArmourerBlockEntity, T> applier, IEntitySerializer<T> dataSerializer, BlockPermission permission) {
            Field field = TYPE.create(dataSerializer).getter(supplier).setter(applier).build(Field::new);
            field.permission = permission;
            return field;
        }

        private void apply(UpdateArmourerPacket packet, Player player, ArmourerBlockEntity blockEntity, ArmourerMenu container) throws Exception {
            if (!this.permission.accept(blockEntity, player)) {
                return;
            }
            if (this.action != null) {
                Object value = Objects.unsafeCast(packet.fieldValue.value());
                this.action.accept(packet, player, blockEntity, container, value);
            } else {
                packet.fieldValue.apply(blockEntity);
            }
        }
    }

    public static interface FieldAction<T> {
        public void accept(UpdateArmourerPacket var1, Player var2, ArmourerBlockEntity var3, ArmourerMenu var4, T var5) throws Exception;
    }
}

